/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.util;

import junitx.framework.ArrayAssert;
import org.seasar.framework.container.ComponentNotFoundRuntimeException;
import org.seasar.teeda.core.unit.TeedaTestCase;
import org.seasar.teeda.core.util.DIContainerUtil;

public class DIContainerUtilTest
extends TeedaTestCase {
    public void testGetComponent_findOne() throws Exception {
        this.getContainer().register(Hoge.class);
        Hoge hoge = (Hoge)DIContainerUtil.getComponent((Object)Hoge.class);
        DIContainerUtilTest.assertNotNull((Object)hoge);
    }

    public void testGetComponent_NotFound() throws Exception {
        try {
            DIContainerUtil.getComponent((Object)Hoge.class);
            DIContainerUtilTest.fail();
        }
        catch (ComponentNotFoundRuntimeException expected) {
            DIContainerUtilTest.success();
        }
    }

    public void testGetComponentNoException_findOne() throws Exception {
        this.getContainer().register(Hoge.class);
        Hoge hoge = (Hoge)DIContainerUtil.getComponentNoException((Object)Hoge.class);
        DIContainerUtilTest.assertNotNull((Object)hoge);
    }

    public void testGetComponentNoException_NotFound() throws Exception {
        Hoge hoge = null;
        try {
            hoge = (Hoge)DIContainerUtil.getComponentNoException((Object)Hoge.class);
        }
        catch (Exception e) {
            DIContainerUtilTest.fail();
        }
        DIContainerUtilTest.assertNull(hoge);
    }

    public void testGetComponentNoException_findOneByClass() throws Exception {
        this.getContainer().register(Hoge.class, "hoge");
        Hoge hoge = (Hoge)DIContainerUtil.getComponentNoException((Object)"hoge");
        DIContainerUtilTest.assertNotNull((Object)hoge);
    }

    public void testGetComponentKeys_sameClass() throws Exception {
        this.getContainer().register(Hoge.class, "hoge1");
        this.getContainer().register(Hoge.class, "hoge2");
        this.getContainer().register(Hoge.class, "hoge3");
        Object[] keys = DIContainerUtil.getComponentKeys((Class)Hoge.class);
        ArrayAssert.assertEquals((Object[])new String[]{"hoge1", "hoge2", "hoge3"}, (Object[])keys);
    }

    public void testGetComponentKeys_includeChildClass() throws Exception {
        this.getContainer().register(Hoge.class, "hoge1");
        this.getContainer().register(Hoge2.class, "hoge2");
        this.getContainer().register(Hoge3.class, "hoge3");
        Object[] keys = DIContainerUtil.getComponentKeys((Class)Hoge.class);
        ArrayAssert.assertEquals((Object[])new String[]{"hoge1", "hoge2", "hoge3"}, (Object[])keys);
    }

    public void testHasComponent() throws Exception {
        this.getContainer().register(Hoge.class, "hoge1");
        DIContainerUtilTest.assertTrue((boolean)DIContainerUtil.hasComponent((Object)Hoge.class));
        DIContainerUtilTest.assertTrue((boolean)DIContainerUtil.hasComponent((Object)"hoge1"));
        DIContainerUtilTest.assertFalse((boolean)DIContainerUtil.hasComponent((Object)"hoge2"));
    }

    public void testHasComponent2() throws Exception {
        this.getContainer().register(Hoge2.class);
        DIContainerUtilTest.assertTrue((boolean)DIContainerUtil.hasComponent((Object)Hoge.class));
        DIContainerUtilTest.assertTrue((boolean)DIContainerUtil.hasComponent((Object)Hoge2.class));
    }

    public static class Hoge3
    extends Hoge2 {
    }

    public static class Hoge2
    extends Hoge {
    }

    public static class Hoge {
    }
}

