/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.render.Renderer;
import javax.faces.render.RendererTest;
import org.custommonkey.xmlunit.Diff;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockHtmlSelectBooleanCheckbox;
import org.seasar.teeda.core.render.html.HtmlSelectBooleanCheckboxRenderer;

public class HtmlSelectBooleanCheckboxRendererTest
extends RendererTest {
    private HtmlSelectBooleanCheckboxRenderer renderer;
    private MockHtmlSelectBooleanCheckbox htmlSelectBooleanCheckbox;

    protected void setUp() throws Exception {
        super.setUp();
        this.renderer = this.createHtmlSelectBooleanCheckboxRenderer();
        this.htmlSelectBooleanCheckbox = new MockHtmlSelectBooleanCheckbox();
        this.htmlSelectBooleanCheckbox.setRenderer((Renderer)this.renderer);
        this.renderer.addIgnoreAttributeName("setSubmittedValueCalls");
    }

    public void testEncode_NoValue() throws Exception {
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectBooleanCheckbox);
        HtmlSelectBooleanCheckboxRendererTest.assertEquals((String)"<input type=\"checkbox\" name=\"_id0\" value=\"true\" />", (String)this.getResponseText());
    }

    public void testEncode_WithUnknownAttribute1() throws Exception {
        this.htmlSelectBooleanCheckbox.getAttributes().put("a", "b");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectBooleanCheckbox);
        HtmlSelectBooleanCheckboxRendererTest.assertEquals((String)"<input type=\"checkbox\" name=\"_id0\" value=\"true\" a=\"b\" />", (String)this.getResponseText());
    }

    public void testEncode_WithUnknownAttribute2() throws Exception {
        this.htmlSelectBooleanCheckbox.getAttributes().put("a.b", "b");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectBooleanCheckbox);
        HtmlSelectBooleanCheckboxRendererTest.assertEquals((String)"<input type=\"checkbox\" name=\"_id0\" value=\"true\" />", (String)this.getResponseText());
    }

    public void testEncode_RenderFalse() throws Exception {
        this.htmlSelectBooleanCheckbox.setRendered(false);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectBooleanCheckbox);
        HtmlSelectBooleanCheckboxRendererTest.assertEquals((String)"", (String)this.getResponseText());
    }

    public void testEncode_WithValue() throws Exception {
        this.htmlSelectBooleanCheckbox.setValue("abc");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectBooleanCheckbox);
        HtmlSelectBooleanCheckboxRendererTest.assertEquals((String)"<input type=\"checkbox\" name=\"_id0\" value=\"true\" />", (String)this.getResponseText());
    }

    public void testEncode_Disabled() throws Exception {
        this.htmlSelectBooleanCheckbox.setValue("abc");
        this.htmlSelectBooleanCheckbox.setDisabled(true);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectBooleanCheckbox);
        HtmlSelectBooleanCheckboxRendererTest.assertEquals((String)"<input type=\"checkbox\" name=\"_id0\" value=\"true\" disabled=\"disabled\" />", (String)this.getResponseText());
    }

    public void testEncode_Checked() throws Exception {
        this.htmlSelectBooleanCheckbox.setValue("true");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectBooleanCheckbox);
        HtmlSelectBooleanCheckboxRendererTest.assertEquals((String)"<input type=\"checkbox\" name=\"_id0\" value=\"true\" checked=\"checked\" />", (String)this.getResponseText());
    }

    public void testEncode_WithAllAttributes() throws Exception {
        this.htmlSelectBooleanCheckbox.setAccesskey("a");
        this.htmlSelectBooleanCheckbox.setDir("c");
        this.htmlSelectBooleanCheckbox.setDisabled(true);
        this.htmlSelectBooleanCheckbox.setLang("e");
        this.htmlSelectBooleanCheckbox.setOnblur("g");
        this.htmlSelectBooleanCheckbox.setOnchange("h");
        this.htmlSelectBooleanCheckbox.setOnclick("i");
        this.htmlSelectBooleanCheckbox.setOndblclick("j");
        this.htmlSelectBooleanCheckbox.setOnfocus("k");
        this.htmlSelectBooleanCheckbox.setOnkeydown("l");
        this.htmlSelectBooleanCheckbox.setOnkeypress("m");
        this.htmlSelectBooleanCheckbox.setOnkeyup("n");
        this.htmlSelectBooleanCheckbox.setOnmousedown("o");
        this.htmlSelectBooleanCheckbox.setOnmousemove("p");
        this.htmlSelectBooleanCheckbox.setOnmouseout("q");
        this.htmlSelectBooleanCheckbox.setOnmouseover("r");
        this.htmlSelectBooleanCheckbox.setOnmouseup("s");
        this.htmlSelectBooleanCheckbox.setOnselect("t");
        this.htmlSelectBooleanCheckbox.setReadonly(true);
        this.htmlSelectBooleanCheckbox.setStyle("w");
        this.htmlSelectBooleanCheckbox.setStyleClass("u");
        this.htmlSelectBooleanCheckbox.setTabindex("x");
        this.htmlSelectBooleanCheckbox.setTitle("y");
        this.htmlSelectBooleanCheckbox.getAttributes().put("type", "checkbox");
        this.htmlSelectBooleanCheckbox.getAttributes().put("checked", "checked");
        this.htmlSelectBooleanCheckbox.setId("A");
        this.htmlSelectBooleanCheckbox.setValue("true");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectBooleanCheckbox);
        Diff diff = new Diff("<input type=\"checkbox\" id=\"A\" name=\"A\" value=\"true\" checked=\"checked\" accesskey=\"a\" dir=\"c\" disabled=\"disabled\" lang=\"e\" onblur=\"g\" onchange=\"h\" onclick=\"i\" ondblclick=\"j\" onfocus=\"k\" onkeydown=\"l\" onkeypress=\"m\" onkeyup=\"n\" onmousedown=\"o\" onmousemove=\"p\" onmouseout=\"q\" onmouseover=\"r\" onmouseup=\"s\" onselect=\"t\" readonly=\"readonly\" style=\"w\" class=\"u\" tabindex=\"x\" title=\"y\"/>", this.getResponseText());
        HtmlSelectBooleanCheckboxRendererTest.assertEquals((String)diff.toString(), (boolean)true, (boolean)diff.identical());
    }

    public void testDecode_RequestParameterNotExist() throws Exception {
        this.htmlSelectBooleanCheckbox.setClientId("key");
        MockFacesContext context = this.getFacesContext();
        this.renderer.decode((FacesContext)context, (UIComponent)this.htmlSelectBooleanCheckbox);
        HtmlSelectBooleanCheckboxRendererTest.assertEquals((int)1, (int)this.htmlSelectBooleanCheckbox.getSetSubmittedValueCalls());
        HtmlSelectBooleanCheckboxRendererTest.assertEquals((Object)"false", (Object)this.htmlSelectBooleanCheckbox.getSubmittedValue());
    }

    public void testDecode_RequestParameterInvalidValue() throws Exception {
        this.htmlSelectBooleanCheckbox.setClientId("key");
        MockFacesContext context = this.getFacesContext();
        context.getExternalContext().getRequestParameterMap().put("key", "aaa");
        this.renderer.decode((FacesContext)context, (UIComponent)this.htmlSelectBooleanCheckbox);
        HtmlSelectBooleanCheckboxRendererTest.assertEquals((int)1, (int)this.htmlSelectBooleanCheckbox.getSetSubmittedValueCalls());
        HtmlSelectBooleanCheckboxRendererTest.assertEquals((Object)"false", (Object)this.htmlSelectBooleanCheckbox.getSubmittedValue());
    }

    public void testDecode_RequestParameterTrue() throws Exception {
        this.decodeSuccessTest("tRue");
    }

    public void testDecode_RequestParameterOn() throws Exception {
        this.decodeSuccessTest("oN");
    }

    public void testDecode_RequestParameterYes() throws Exception {
        this.decodeSuccessTest("yes");
    }

    private void decodeSuccessTest(String input) throws Exception {
        this.htmlSelectBooleanCheckbox.setClientId("keyA");
        MockFacesContext context = this.getFacesContext();
        context.getExternalContext().getRequestParameterMap().put("keyA", input);
        this.renderer.decode((FacesContext)context, (UIComponent)this.htmlSelectBooleanCheckbox);
        HtmlSelectBooleanCheckboxRendererTest.assertEquals((int)1, (int)this.htmlSelectBooleanCheckbox.getSetSubmittedValueCalls());
        HtmlSelectBooleanCheckboxRendererTest.assertEquals((Object)"true", (Object)this.htmlSelectBooleanCheckbox.getSubmittedValue());
    }

    public void testGetRendersChildren() throws Exception {
        HtmlSelectBooleanCheckboxRendererTest.assertEquals((boolean)false, (boolean)this.renderer.getRendersChildren());
    }

    private HtmlSelectBooleanCheckboxRenderer createHtmlSelectBooleanCheckboxRenderer() {
        return (HtmlSelectBooleanCheckboxRenderer)this.createRenderer();
    }

    protected Renderer createRenderer() {
        HtmlSelectBooleanCheckboxRenderer renderer = new HtmlSelectBooleanCheckboxRenderer();
        renderer.setComponentIdLookupStrategy(this.getComponentIdLookupStrategy());
        return renderer;
    }
}

