/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.managedbean.impl;

import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.seasar.teeda.core.managedbean.IllegalManagedBeanScopeException;
import org.seasar.teeda.core.managedbean.impl.ManagedBeanScopeSaverImpl;
import org.seasar.teeda.core.scope.Scope;
import org.seasar.teeda.core.scope.ScopeSaver;
import org.seasar.teeda.core.unit.TeedaTestCase;

public class ManagedBeanScopeSaverImplTest
extends TeedaTestCase {
    public ManagedBeanScopeSaverImplTest(String arg0) {
        super(arg0);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testSaveToScope1() {
        ManagedBeanScopeSaverImpl saver = new ManagedBeanScopeSaverImpl();
        saver.saveToScope((FacesContext)this.getFacesContext(), Scope.APPLICATION, "hoge", (Object)"foo");
        ManagedBeanScopeSaverImplTest.assertEquals((Object)"foo", this.getFacesContext().getExternalContext().getApplicationMap().get("hoge"));
        saver.saveToScope((FacesContext)this.getFacesContext(), Scope.SESSION, "hoge", (Object)"foo");
        ManagedBeanScopeSaverImplTest.assertEquals((Object)"foo", this.getFacesContext().getExternalContext().getSessionMap().get("hoge"));
        saver.saveToScope((FacesContext)this.getFacesContext(), Scope.REQUEST, "hoge", (Object)"foo");
        ManagedBeanScopeSaverImplTest.assertEquals((Object)"foo", this.getFacesContext().getExternalContext().getRequestMap().get("hoge"));
    }

    public void testSaveToScope2() {
        ManagedBeanScopeSaverImpl saver = new ManagedBeanScopeSaverImpl();
        try {
            saver.saveToScope((FacesContext)this.getFacesContext(), new Scope(){

                public String getScopeKey() {
                    return "hoge";
                }
            }, "hoge", (Object)"foo");
            ManagedBeanScopeSaverImplTest.fail();
        }
        catch (IllegalManagedBeanScopeException expected) {
            ManagedBeanScopeSaverImplTest.success();
        }
    }

    public void testAddScope() {
        ManagedBeanScopeSaverImpl saver = new ManagedBeanScopeSaverImpl();
        HashMap map = new HashMap();
        CustomScopeSaver customSaver = new CustomScopeSaver(map);
        HogeScope scope = new HogeScope();
        saver.addScope((Scope)scope, (ScopeSaver)customSaver);
        saver.saveToScope((FacesContext)this.getFacesContext(), (Scope)scope, "a", (Object)"b");
        ManagedBeanScopeSaverImplTest.assertEquals((Object)"b", map.get("a"));
    }

    private static class CustomScopeSaver
    implements ScopeSaver {
        private Map map_;

        public CustomScopeSaver(Map map) {
            this.map_ = map;
        }

        public void saveToScope(FacesContext context, String key, Object value) {
            this.map_.put(key, value);
        }
    }

    private static class HogeScope
    implements Scope {
        private HogeScope() {
        }

        public String getScopeKey() {
            return "hoge";
        }
    }
}

