/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.lifecycle.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import javax.faces.internal.WindowIdUtil;
import javax.faces.internal.scope.PageScope;
import org.seasar.framework.mock.servlet.MockHttpServletRequest;
import org.seasar.teeda.core.application.ViewHandlerImpl;
import org.seasar.teeda.core.lifecycle.impl.RestoreViewPhase;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockUIViewRoot;
import org.seasar.teeda.core.unit.TeedaTestCase;
import org.seasar.teeda.core.util.PostbackUtil;

public class RestoreViewPhaseTest
extends TeedaTestCase {
    public void testGetCurrentPhaseId() throws Exception {
        RestoreViewPhaseTest.assertEquals((Object)PhaseId.RESTORE_VIEW, (Object)new RestoreViewPhase().getCurrentPhaseId());
    }

    public void testRestoredViewRootHasClientLocale() throws Exception {
        MockFacesContext context = this.getFacesContext();
        RestoreViewPhase phase = new RestoreViewPhase();
        MockHttpServletRequest request = context.getMockExternalContext().getMockHttpServletRequest();
        request.setLocale(Locale.ITALY);
        final MockUIViewRoot mockUIViewRoot = new MockUIViewRoot();
        mockUIViewRoot.setLocale(Locale.CANADA);
        Application application = context.getApplication();
        application.setViewHandler((ViewHandler)new ViewHandlerImpl(){

            public UIViewRoot restoreView(FacesContext context, String viewId) {
                return mockUIViewRoot;
            }
        });
        application.setSupportedLocales(Arrays.asList(Locale.ITALY, Locale.CANADA));
        phase.executePhase((FacesContext)context);
        RestoreViewPhaseTest.assertSame((Object)((Object)mockUIViewRoot), (Object)context.getViewRoot());
        RestoreViewPhaseTest.assertEquals((Object)Locale.ITALY, (Object)context.getViewRoot().getLocale());
    }

    public void testGetViewIdMruFromSession() throws Exception {
        RestoreViewPhase phase = new RestoreViewPhase();
        phase.setViewIdLruSize(3);
        HashMap sessionMap = new HashMap();
        Map lru = phase.getViewIdLruFromSession(sessionMap);
        lru.put("aaa", "111");
        lru.put("bbb", "222");
        lru.put("ccc", "333");
        lru.get("aaa");
        Iterator i = lru.keySet().iterator();
        RestoreViewPhaseTest.assertEquals((Object)"bbb", i.next());
        RestoreViewPhaseTest.assertEquals((Object)"ccc", i.next());
        RestoreViewPhaseTest.assertEquals((Object)"aaa", i.next());
        lru.put("ddd", "444");
        RestoreViewPhaseTest.assertNull(lru.get("bbb"));
    }

    public void testSaveViewIdToSession() throws Exception {
        RestoreViewPhase phase = new RestoreViewPhase();
        HashMap sessionMap = new HashMap();
        phase.saveViewIdToSession(sessionMap, "123", "hoge.html");
        RestoreViewPhaseTest.assertEquals((String)"hoge.html", (String)phase.getViewIdFromSession(sessionMap, "123"));
    }

    public void testViewScope() throws Exception {
        String wid = "123";
        RestoreViewPhase phase = new RestoreViewPhase();
        Map sessionMap = this.getExternalContext().getSessionMap();
        Map paramMap = this.getExternalContext().getRequestParameterMap();
        paramMap.put("wid", wid);
        phase.saveViewIdToSession(sessionMap, wid, "hoge.html");
        this.getExternalContext().setRequestPathInfo("hoge2.html");
        Map ctx = PageScope.getOrCreateContext((FacesContext)this.getFacesContext());
        ctx.put("aaa", "111");
        WindowIdUtil.setupWindowId((ExternalContext)this.getExternalContext());
        phase.executePhase((FacesContext)this.getFacesContext());
        ctx = PageScope.getOrCreateContext((FacesContext)this.getFacesContext());
        RestoreViewPhaseTest.assertNull(ctx.get("aaa"));
    }

    public void testPostbackTrue() throws Exception {
        RestoreViewPhase phase = new RestoreViewPhase(){

            protected String getViewIdFromSession(Map sessionMap, String windowId) {
                return "/fooViewId";
            }
        };
        MockFacesContext context = this.getFacesContext();
        MockHttpServletRequest request = this.getRequest();
        request.setPathInfo("/fooViewId");
        request.setMethod("POST");
        phase.executePhase((FacesContext)context);
        RestoreViewPhaseTest.assertEquals((boolean)true, (boolean)PostbackUtil.isPostback((Map)context.getExternalContext().getRequestMap()));
    }

    public void testPostbackFalse2() throws Exception {
        RestoreViewPhase phase = new RestoreViewPhase(){

            protected String getViewIdFromSession(Map sessionMap, String windowId) {
                return "/fooViewId";
            }
        };
        MockFacesContext context = this.getFacesContext();
        MockHttpServletRequest request = this.getRequest();
        request.setPathInfo("/fooViewId");
        request.setMethod("GET");
        phase.executePhase((FacesContext)context);
        RestoreViewPhaseTest.assertEquals((boolean)false, (boolean)PostbackUtil.isPostback((Map)context.getExternalContext().getRequestMap()));
    }
}

