/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.config.faces.handler;

import java.util.List;
import java.util.Map;
import org.seasar.teeda.core.config.faces.element.AttributeElement;
import org.seasar.teeda.core.config.faces.element.ConverterElement;
import org.seasar.teeda.core.config.faces.element.FacesConfig;
import org.seasar.teeda.core.config.faces.element.PropertyElement;
import org.seasar.teeda.core.config.faces.element.impl.ConverterElementImpl;
import org.seasar.teeda.core.config.faces.element.impl.FacesConfigImpl;
import org.seasar.teeda.core.config.faces.handler.ConverterTagHandler;
import org.seasar.teeda.core.config.faces.handler.TagHandlerTestCase;
import org.seasar.teeda.core.mock.MockConverter;
import org.xml.sax.Attributes;

public class ConverterTagHandlerTest
extends TagHandlerTestCase {
    public ConverterTagHandlerTest(String name) {
        super(name);
    }

    public void testConverterTagHandler_withConverterId() throws Exception {
        FacesConfigImpl facesConfig = new FacesConfigImpl();
        this.getContext().push((Object)facesConfig);
        ConverterTagHandler handler = new ConverterTagHandler(){

            protected ConverterElement createConverterElement() {
                ConverterElementImpl c = new ConverterElementImpl();
                c.setConverterId("aaa");
                return c;
            }
        };
        handler.start(this.getContext(), (Attributes)new TagHandlerTestCase.NullAttributes());
        handler.end(this.getContext(), "a");
        Map converters = facesConfig.getConverterElementsById();
        ConverterTagHandlerTest.assertNotNull((Object)converters);
        ConverterTagHandlerTest.assertEquals((int)1, (int)converters.entrySet().size());
        ConverterElement converter = (ConverterElement)converters.get("aaa");
        ConverterTagHandlerTest.assertEquals((String)"aaa", (String)converter.getConverterId());
    }

    public void testConverterTagHandler_withConverterForClass() throws Exception {
        FacesConfigImpl facesConfig = new FacesConfigImpl();
        this.getContext().push((Object)facesConfig);
        ConverterTagHandler handler = new ConverterTagHandler(){

            protected ConverterElement createConverterElement() {
                ConverterElementImpl c = new ConverterElementImpl();
                c.setConverterForClass("aaa");
                return c;
            }
        };
        handler.start(this.getContext(), (Attributes)new TagHandlerTestCase.NullAttributes());
        handler.end(this.getContext(), "a");
        Map converters = facesConfig.getConverterElementsByClass();
        ConverterTagHandlerTest.assertNotNull((Object)converters);
        ConverterTagHandlerTest.assertEquals((int)1, (int)converters.entrySet().size());
        ConverterElement converter = (ConverterElement)converters.get("aaa");
        ConverterTagHandlerTest.assertEquals((String)"aaa", (String)converter.getConverterForClass());
    }

    public void testConverterTagHandlerByXMLParse() throws Exception {
        FacesConfig facesConfig = this.parse("testConverterTagHandler.xml");
        Map map = facesConfig.getConverterElementsById();
        ConverterTagHandlerTest.assertEquals((int)1, (int)map.values().size());
        ConverterElement converter = (ConverterElement)map.get("javax.faces.mock");
        ConverterTagHandlerTest.assertEquals((String)"javax.faces.mock", (String)converter.getConverterId());
        ConverterTagHandlerTest.assertNull((Object)converter.getConverterForClass());
        ConverterTagHandlerTest.assertEquals((String)MockConverter.class.getName(), (String)converter.getConverterClass());
        List attributes = converter.getAttributeElements();
        ConverterTagHandlerTest.assertNotNull((Object)attributes);
        ConverterTagHandlerTest.assertEquals((int)1, (int)attributes.size());
        AttributeElement attribute = (AttributeElement)attributes.get(0);
        ConverterTagHandlerTest.assertEquals((String)"attr", (String)attribute.getAttributeName());
        ConverterTagHandlerTest.assertEquals((String)"A", (String)attribute.getAttributeClass());
        map = facesConfig.getConverterElementsByClass();
        converter = (ConverterElement)map.get("java.lang.Double");
        List properties = converter.getPropertyElements();
        ConverterTagHandlerTest.assertNotNull((Object)properties);
        ConverterTagHandlerTest.assertEquals((int)1, (int)properties.size());
        PropertyElement property = (PropertyElement)properties.get(0);
        ConverterTagHandlerTest.assertEquals((String)"b", (String)property.getPropertyName());
        ConverterTagHandlerTest.assertEquals((String)"B", (String)property.getPropertyClass());
        ConverterTagHandlerTest.assertNull((Object)property.getDefaultValue());
    }
}

