/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.config.faces.assembler;

import java.util.HashMap;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.convert.Converter;
import javax.faces.internal.FactoryFinderUtil;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.application.ApplicationImpl;
import org.seasar.teeda.core.application.ComponentLookupStrategy;
import org.seasar.teeda.core.application.ConfigurationSupport;
import org.seasar.teeda.core.application.ConverterConfiguration;
import org.seasar.teeda.core.application.impl.DefaultComponentLookupStrategy;
import org.seasar.teeda.core.config.faces.assembler.ConverterChildAssembler;
import org.seasar.teeda.core.config.faces.element.ConverterElement;
import org.seasar.teeda.core.config.faces.element.PropertyElement;
import org.seasar.teeda.core.config.faces.element.impl.ConverterElementImpl;
import org.seasar.teeda.core.config.faces.element.impl.PropertyElementImpl;
import org.seasar.teeda.core.mock.MockApplication;
import org.seasar.teeda.core.mock.MockConverter;
import org.seasar.teeda.core.unit.TeedaTestCase;

public class ConverterChildAssemblerTest
extends TeedaTestCase {
    public void testAssemble_withConverterId() throws Exception {
        ConverterElementImpl cElement = new ConverterElementImpl();
        cElement.setConverterClass("org.seasar.teeda.core.mock.MockConverter");
        cElement.setConverterId("id");
        HashMap<String, ConverterElementImpl> map = new HashMap<String, ConverterElementImpl>();
        map.put(cElement.getConverterId(), cElement);
        MockConverterChildAssemblerForId assembler = new MockConverterChildAssemblerForId(map);
        assembler.assemble();
        Converter c = this.getApplication().createConverter("id");
        ConverterChildAssemblerTest.assertNotNull((Object)c);
        ConverterChildAssemblerTest.assertTrue((boolean)(c instanceof MockConverter));
    }

    public void testAssemble_withConverterForClass() throws Exception {
        ConverterElementImpl cElement = new ConverterElementImpl();
        cElement.setConverterClass("org.seasar.teeda.core.mock.MockConverter");
        cElement.setConverterForClass(Hoge.class.getName());
        HashMap<String, ConverterElementImpl> map = new HashMap<String, ConverterElementImpl>();
        map.put(cElement.getConverterForClass(), cElement);
        MockConverterChildAssembler2 assembler = new MockConverterChildAssembler2(map);
        assembler.assemble();
        Converter c = this.getApplication().createConverter(Hoge.class);
        ConverterChildAssemblerTest.assertNotNull((Object)c);
        ConverterChildAssemblerTest.assertTrue((boolean)(c instanceof MockConverter));
    }

    public void testAssemble_withNoConverterId() throws Exception {
        ConverterElementImpl cElement = new ConverterElementImpl();
        cElement.setConverterClass("org.seasar.teeda.core.mock.MockConverter");
        cElement.setConverterId("");
        HashMap<String, ConverterElementImpl> map = new HashMap<String, ConverterElementImpl>();
        map.put(cElement.getConverterId(), cElement);
        MockConverterChildAssemblerForId assembler = new MockConverterChildAssemblerForId(map);
        assembler.assemble();
        Converter c = this.getApplication().createConverter("");
        ConverterChildAssemblerTest.assertNull((Object)c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAssemble_withConverterConfiguration() throws Exception {
        MockApplication previous = this.getApplication();
        ApplicationFactory appFactory = FactoryFinderUtil.getApplicationFactory();
        try {
            ApplicationImpl app = new ApplicationImpl();
            app.setComponentLookupStrategy((ComponentLookupStrategy)new DefaultComponentLookupStrategy());
            appFactory.setApplication((Application)app);
            ConverterElementImpl cElement = new ConverterElementImpl();
            cElement.setConverterClass("org.seasar.teeda.core.mock.MockConverter");
            cElement.setConverterId("id");
            PropertyElementImpl pElement = new PropertyElementImpl();
            pElement.setPropertyName("name");
            pElement.setPropertyClass("String");
            pElement.setDefaultValue("hoge");
            cElement.addPropertyElement((PropertyElement)pElement);
            HashMap<String, ConverterElementImpl> map = new HashMap<String, ConverterElementImpl>();
            map.put(cElement.getConverterId(), cElement);
            MockConverterChildAssemblerForId assembler = new MockConverterChildAssemblerForId(map);
            assembler.assemble();
            Converter c = appFactory.getApplication().createConverter("id");
            ConverterChildAssemblerTest.assertNotNull((Object)c);
            ConverterChildAssemblerTest.assertTrue((boolean)(c instanceof MockConverter));
            ConverterChildAssemblerTest.assertEquals((String)"hoge", (String)((MockConverter)c).getName());
        }
        finally {
            appFactory.setApplication((Application)previous);
        }
    }

    private static class Hoge {
        private Hoge() {
        }
    }

    private static class MockConverterChildAssembler2
    extends ConverterChildAssembler {
        public MockConverterChildAssembler2(Map targetMap) {
            super(targetMap);
        }

        protected void doAssemble(String converterForClass, ConverterElement converterElement) {
            String converterClass = converterElement.getConverterClass();
            if (!StringUtil.isEmpty((String)converterClass)) {
                Class targetClazz = ClassUtil.forName((String)converterForClass);
                this.getApplication().addConverter(targetClazz, converterClass);
            }
        }

        protected void doAddConverterConfiguration(ConfigurationSupport support, String converterKey, ConverterConfiguration configuration) {
        }
    }

    private static class MockConverterChildAssemblerForId
    extends ConverterChildAssembler {
        public MockConverterChildAssemblerForId(Map targetMap) {
            super(targetMap);
        }

        protected void doAssemble(String converterId, ConverterElement converterElement) {
            String converterClass = converterElement.getConverterClass();
            if (!StringUtil.isEmpty((String)converterClass)) {
                this.getApplication().addConverter(converterId, converterClass);
            }
        }

        protected void doAddConverterConfiguration(ConfigurationSupport support, String converterKey, ConverterConfiguration configuration) {
            support.addConverterConfiguration(converterKey, configuration);
        }
    }
}

