/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.application.navigation;

import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.seasar.teeda.core.application.navigation.NavigationCaseContext;
import org.seasar.teeda.core.application.navigation.NavigationContext;
import org.seasar.teeda.core.application.navigation.NavigationResource;

public class NavigationResourceTest
extends TestCase {
    public void tearDown() {
        NavigationResource.removeAll();
    }

    public void testAddNavigationContext_navigationContextIsNull() throws Exception {
        try {
            NavigationResource.addNavigationContext(null);
            NavigationResourceTest.fail();
        }
        catch (IllegalArgumentException expected) {
            NavigationResourceTest.assertTrue((boolean)true);
        }
    }

    public void testAddNavigationContext_getNavigationContext() throws Exception {
        NavigationContext navContext = new NavigationContext();
        navContext.setFromViewId("fromId");
        NavigationCaseContext caseContext = new NavigationCaseContext();
        caseContext.setToViewId("toId");
        caseContext.setFromAction("action");
        caseContext.setFromOutcome("outcome");
        caseContext.setRedirect(true);
        navContext.addNavigationCaseContext(caseContext);
        NavigationResource.addNavigationContext((NavigationContext)navContext);
        Map map = NavigationResource.getNavigationContexts();
        List list = (List)map.get("fromId");
        NavigationContext targetContext = (NavigationContext)list.get(0);
        NavigationResourceTest.assertNotNull((Object)targetContext);
        NavigationResourceTest.assertEquals((String)"fromId", (String)targetContext.getFromViewId());
        NavigationResourceTest.assertNotNull((Object)targetContext.getNavigationCase("action", "outcome"));
        NavigationCaseContext targetCase = targetContext.getNavigationCase("action", "outcome");
        NavigationResourceTest.assertEquals((String)"action", (String)targetCase.getFromAction());
        NavigationResourceTest.assertEquals((String)"outcome", (String)targetCase.getFromOutcome());
        NavigationResourceTest.assertEquals((String)"toId", (String)targetCase.getToViewId());
    }

    public void testAddNavigationContext_getWildCardNavigationContext() throws Exception {
        NavigationContext navContext = new NavigationContext();
        navContext.setFromViewId("aa*");
        NavigationCaseContext caseContext = new NavigationCaseContext();
        caseContext.setToViewId("toId");
        caseContext.setFromAction("action");
        caseContext.setFromOutcome("outcome");
        caseContext.setRedirect(true);
        navContext.addNavigationCaseContext(caseContext);
        NavigationResource.addNavigationContext((NavigationContext)navContext);
        Map map = NavigationResource.getWildCardMatchNavigationContexts();
        List list = (List)map.get("aa*");
        NavigationContext targetContext = (NavigationContext)list.get(0);
        NavigationResourceTest.assertNotNull((Object)targetContext);
        NavigationResourceTest.assertEquals((String)"aa*", (String)targetContext.getFromViewId());
        NavigationResourceTest.assertNotNull((Object)targetContext.getNavigationCase("action", "outcome"));
        NavigationCaseContext targetCase = targetContext.getNavigationCase("action", "outcome");
        NavigationResourceTest.assertEquals((String)"action", (String)targetCase.getFromAction());
        NavigationResourceTest.assertEquals((String)"outcome", (String)targetCase.getFromOutcome());
        NavigationResourceTest.assertEquals((String)"toId", (String)targetCase.getToViewId());
    }

    public void testRemoveNavigationContext() throws Exception {
        NavigationContext navContext = new NavigationContext();
        navContext.setFromViewId("fromId");
        NavigationCaseContext caseContext = new NavigationCaseContext();
        caseContext.setToViewId("toId");
        caseContext.setFromAction("action");
        caseContext.setFromOutcome("outcome");
        caseContext.setRedirect(true);
        navContext.addNavigationCaseContext(caseContext);
        NavigationResource.addNavigationContext((NavigationContext)navContext);
        NavigationResource.removeNavigationContext((String)"fromId");
        Map map = NavigationResource.getNavigationContexts();
        NavigationResourceTest.assertNull(map.get("fromId"));
    }
}

