/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.model;

import javax.faces.model.ArrayDataModel;
import javax.faces.model.DataModelEvent;
import javax.faces.model.DataModelListener;
import junit.framework.TestCase;
import org.seasar.teeda.core.mock.MockDataModelListener;

public class ArrayDataModelTest
extends TestCase {
    public void testIsRowAvailable() throws Exception {
        Object[] arrays = new Object[]{"1", "2"};
        ArrayDataModel model = new ArrayDataModel(arrays);
        model.setRowIndex(0);
        ArrayDataModelTest.assertTrue((boolean)model.isRowAvailable());
        model.setRowIndex(arrays.length - 1);
        ArrayDataModelTest.assertTrue((boolean)model.isRowAvailable());
        model.setRowIndex(-1);
        ArrayDataModelTest.assertFalse((boolean)model.isRowAvailable());
    }

    public void testGetRowCount() throws Exception {
        Object[] arrays = new Object[]{"1", "2"};
        ArrayDataModel model = new ArrayDataModel(arrays);
        ArrayDataModelTest.assertEquals((int)arrays.length, (int)model.getRowCount());
        model = new ArrayDataModel();
        ArrayDataModelTest.assertEquals((int)-1, (int)model.getRowCount());
    }

    public void testGetRowData() throws Exception {
        Object[] arrays = new Object[]{"1", "2"};
        ArrayDataModel model = new ArrayDataModel(arrays);
        model.setRowIndex(1);
        ArrayDataModelTest.assertEquals((Object)arrays[1], (Object)model.getRowData());
        model = new ArrayDataModel();
        ArrayDataModelTest.assertEquals(null, (Object)model.getRowData());
        model = new ArrayDataModel(arrays);
        model.setRowIndex(3);
        try {
            model.getRowData();
            ArrayDataModelTest.fail();
        }
        catch (IllegalArgumentException e) {
            ArrayDataModelTest.assertTrue((boolean)true);
        }
    }

    public void testGetRowIndex() throws Exception {
        ArrayDataModel model = new ArrayDataModel(new Object[]{"a", "b"});
        model.setRowIndex(1);
        ArrayDataModelTest.assertEquals((int)1, (int)model.getRowIndex());
        model = new ArrayDataModel();
        ArrayDataModelTest.assertEquals((int)-1, (int)model.getRowIndex());
    }

    public void testSetRowIndex() throws Exception {
        Object[] arrays = new Object[]{"1", "2"};
        ArrayDataModel model = new ArrayDataModel(arrays);
        MockDataModelListener listener = new MockDataModelListener();
        model.addDataModelListener((DataModelListener)listener);
        model.setRowIndex(1);
        DataModelEvent event = listener.getDataModelEvent();
        ArrayDataModelTest.assertEquals((Object)"2", (Object)event.getRowData());
        ArrayDataModelTest.assertEquals((int)1, (int)event.getRowIndex());
        try {
            model.setRowIndex(-2);
            ArrayDataModelTest.fail();
        }
        catch (IllegalArgumentException e) {
            ArrayDataModelTest.assertTrue((boolean)true);
        }
        ArrayDataModel model2 = new ArrayDataModel();
        MockDataModelListener listener2 = new MockDataModelListener();
        model2.addDataModelListener((DataModelListener)listener2);
        model2.setRowIndex(1);
        ArrayDataModelTest.assertNull((Object)listener2.getDataModelEvent());
        ArrayDataModel model3 = new ArrayDataModel(new Object[]{"a", "b"});
        MockDataModelListener listener3 = new MockDataModelListener();
        model3.addDataModelListener((DataModelListener)listener3);
        model3.setRowIndex(3);
        DataModelEvent event3 = listener3.getDataModelEvent();
        ArrayDataModelTest.assertNull((Object)event3.getRowData());
        ArrayDataModelTest.assertEquals((int)3, (int)event3.getRowIndex());
    }

    public void testGetWrappedData() throws Exception {
        Object[] arrays = new Object[]{"3", "4"};
        ArrayDataModel model = new ArrayDataModel();
        model.setWrappedData((Object)arrays);
        ArrayDataModelTest.assertEquals((Object)arrays, (Object)model.getWrappedData());
    }

    public void testSetWrappedData() throws Exception {
        Object[] arrays = new Object[]{"3", "4"};
        ArrayDataModel model = new ArrayDataModel();
        MockDataModelListener listener = new MockDataModelListener();
        model.addDataModelListener((DataModelListener)listener);
        model.setWrappedData((Object)arrays);
        ArrayDataModelTest.assertEquals((int)0, (int)model.getRowIndex());
        ArrayDataModelTest.assertNotNull((Object)model.getWrappedData());
        DataModelEvent event = listener.getDataModelEvent();
        ArrayDataModelTest.assertNotNull((Object)event);
        ArrayDataModelTest.assertEquals((Object)"3", (Object)event.getRowData());
        ArrayDataModelTest.assertEquals((int)0, (int)event.getRowIndex());
    }
}

