/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.internal;

import java.util.HashMap;
import javax.faces.context.ExternalContext;
import javax.faces.internal.WindowIdUtil;
import org.seasar.teeda.core.lifecycle.impl.RestoreViewPhase;
import org.seasar.teeda.core.unit.TeedaTestCase;

public class WindowIdUtilTest
extends TeedaTestCase {
    public void testCreateWindowId() throws Exception {
        String wid = WindowIdUtil.createWindowId();
        System.out.println(wid);
        WindowIdUtilTest.assertNotNull((Object)wid);
        String wid2 = WindowIdUtil.createWindowId();
        System.out.println(wid2);
        WindowIdUtilTest.assertFalse((boolean)wid.equals(wid2));
    }

    public void testIsNewWindowTarget() throws Exception {
        WindowIdUtilTest.assertTrue((boolean)WindowIdUtil.isNewWindowTarget((String)"_blank"));
        WindowIdUtilTest.assertTrue((boolean)WindowIdUtil.isNewWindowTarget((String)"hoge"));
        WindowIdUtilTest.assertFalse((boolean)WindowIdUtil.isNewWindowTarget((String)"_self"));
        WindowIdUtilTest.assertFalse((boolean)WindowIdUtil.isNewWindowTarget((String)""));
    }

    public void testNeedNewWindow() throws Exception {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        WindowIdUtilTest.assertFalse((boolean)WindowIdUtil.needNewWindow(parameterMap));
        parameterMap.put("newwindow", "false");
        WindowIdUtilTest.assertFalse((boolean)WindowIdUtil.needNewWindow(parameterMap));
        parameterMap.put("newwindow", "true");
        WindowIdUtilTest.assertTrue((boolean)WindowIdUtil.needNewWindow(parameterMap));
    }

    public void testSetupWindowId() throws Exception {
        RestoreViewPhase phase = new RestoreViewPhase();
        phase.setViewIdLruSize(3);
        WindowIdUtilTest.assertNull((Object)WindowIdUtil.setupWindowId((ExternalContext)this.getExternalContext()));
        this.getExternalContext().getRequestParameterMap().put("newwindow", "true");
        String wid = WindowIdUtil.setupWindowId((ExternalContext)this.getExternalContext());
        WindowIdUtilTest.assertNotNull((Object)wid);
        WindowIdUtilTest.assertEquals((String)wid, (String)WindowIdUtil.getWindowId((ExternalContext)this.getExternalContext()));
    }
}

