/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.convert;

import javax.faces.application.FacesMessage;
import javax.faces.convert.ConverterException;
import junit.framework.TestCase;

public class ConverterExceptionTest
extends TestCase {
    public void testConverterException() {
        ConverterException e = new ConverterException();
        ConverterExceptionTest.assertNull((Object)e.getFacesMessage());
    }

    public void testConverterExceptionString() {
        ConverterException e = new ConverterException("a");
        ConverterExceptionTest.assertEquals((String)"a", (String)e.getMessage());
    }

    public void testConverterExceptionThrowable() {
        Throwable t = new Throwable("a");
        ConverterException e = new ConverterException(t);
        ConverterExceptionTest.assertEquals((Object)t, (Object)e.getCause());
        ConverterExceptionTest.assertEquals((String)t.getMessage(), (String)e.getCause().getMessage());
    }

    public void testConverterExceptionStringThrowable() {
        String s = "a";
        Throwable t = new Throwable("b");
        ConverterException e = new ConverterException(s, t);
        ConverterExceptionTest.assertEquals((String)s, (String)e.getMessage());
        ConverterExceptionTest.assertEquals((Object)t, (Object)e.getCause());
        ConverterExceptionTest.assertEquals((String)t.getMessage(), (String)e.getCause().getMessage());
    }

    public void testConverterExceptionFacesMessage() {
        FacesMessage facesMessage = new FacesMessage("summary", "detail");
        ConverterException e = new ConverterException(facesMessage);
        ConverterExceptionTest.assertNotNull((Object)e.getFacesMessage());
        ConverterExceptionTest.assertEquals((Object)facesMessage, (Object)e.getFacesMessage());
    }

    public void testConverterExceptionFacesMessageThrowable() {
        FacesMessage facesMessage = new FacesMessage("summary", "detail");
        Throwable t = new Throwable("t");
        ConverterException e = new ConverterException(facesMessage, t);
        ConverterExceptionTest.assertNotNull((Object)e.getFacesMessage());
        ConverterExceptionTest.assertEquals((Object)facesMessage, (Object)e.getFacesMessage());
        ConverterExceptionTest.assertEquals((Object)t, (Object)e.getCause());
    }

    public void testGetFacesMessage() {
        String s = "summary";
        String d = "detail";
        FacesMessage facesMessage = new FacesMessage(s, d);
        ConverterException e = new ConverterException(facesMessage);
        ConverterExceptionTest.assertNotNull((Object)e.getFacesMessage());
        ConverterExceptionTest.assertEquals((Object)facesMessage, (Object)e.getFacesMessage());
        ConverterExceptionTest.assertEquals((String)facesMessage.getDetail(), (String)e.getMessage());
    }
}

