/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.convert;

import java.math.BigInteger;
import java.util.Locale;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.AbstractConverterTestCase;
import javax.faces.convert.BigIntegerConverter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.seasar.teeda.core.mock.MockUIComponent;

public class BigIntegerConverterTest
extends AbstractConverterTestCase {
    public void testGetAsObject_convertSuccess() throws Exception {
        Converter converter = this.createConverter();
        BigInteger b = new BigInteger("2").pow(32);
        String value = b.toString();
        Object o = converter.getAsObject((FacesContext)this.getFacesContext(), (UIComponent)new MockUIComponent(), value);
        BigIntegerConverterTest.assertTrue((boolean)(o instanceof BigInteger));
        BigInteger result = (BigInteger)o;
        BigIntegerConverterTest.assertTrue((boolean)b.equals(result));
        BigIntegerConverterTest.assertEquals((long)b.longValue(), (long)result.longValue());
    }

    public void testGetAsObject_convertFail() throws Exception {
        Converter converter = this.createConverter();
        String value = "aaa";
        try {
            converter.getAsObject((FacesContext)this.getFacesContext(), (UIComponent)new MockUIComponent(), value);
            BigIntegerConverterTest.fail();
        }
        catch (ConverterException e) {
            BigIntegerConverterTest.success();
        }
    }

    public void testGetAsString_convertSuccess() throws Exception {
        Converter converter = this.createConverter();
        BigInteger b = new BigInteger("123");
        String str = converter.getAsString((FacesContext)this.getFacesContext(), (UIComponent)new MockUIComponent(), (Object)b);
        BigIntegerConverterTest.assertEquals((String)b.toString(), (String)str);
    }

    public void testGetAsString_convertFail() throws Exception {
        Converter converter = this.createConverter();
        Boolean bl = new Boolean(true);
        try {
            converter.getAsString((FacesContext)this.getFacesContext(), (UIComponent)new MockUIComponent(), (Object)bl);
            BigIntegerConverterTest.fail();
        }
        catch (ConverterException e) {
            BigIntegerConverterTest.assertTrue((boolean)true);
        }
    }

    public void testGetAsObject_convertWithDelimeter() throws Exception {
        Converter converter = this.createConverter();
        String value = "4,294,967,296";
        this.getFacesContext().getViewRoot().setLocale(Locale.JAPAN);
        Object o = converter.getAsObject((FacesContext)this.getFacesContext(), (UIComponent)new MockUIComponent(), value);
        BigIntegerConverterTest.assertTrue((boolean)(o instanceof BigInteger));
        BigInteger result = (BigInteger)o;
        BigIntegerConverterTest.assertEquals((long)Long.valueOf(value.replaceAll(",", "")), (long)result.longValue());
    }

    public void testConstants() throws Exception {
        BigIntegerConverterTest.assertEquals((String)"javax.faces.BigInteger", (String)"javax.faces.BigInteger");
    }

    protected Converter createConverter() {
        return this.createBigIntegerConverter();
    }

    protected BigIntegerConverter createBigIntegerConverter() {
        return new BigIntegerConverter();
    }
}

