/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.io.Serializable;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBaseTeedaTest;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.FacesEvent;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockSerializableActionListener;
import org.seasar.teeda.core.mock.MockSerializableMethodBinding;

public class UICommandTeedaTest
extends UIComponentBaseTeedaTest {
    public void testSaveAndRestoreState() throws Exception {
        super.testSaveAndRestoreState();
        UICommand command1 = this.createUICommand();
        command1.addActionListener((ActionListener)new MockSerializableActionListener());
        command1.setAction((MethodBinding)new MockSerializableMethodBinding());
        command1.setActionListener((MethodBinding)new MockSerializableMethodBinding());
        command1.setImmediate(true);
        command1.setValue((Object)"bb");
        MockFacesContext context = this.getFacesContext();
        Object state = command1.saveState((FacesContext)context);
        UICommandTeedaTest.assertTrue((boolean)(state instanceof Serializable));
        UICommand command2 = this.createUICommand();
        command2.restoreState((FacesContext)context, this.serializeAndDeserialize(state));
        UICommandTeedaTest.assertEquals((int)command1.getActionListeners().length, (int)command2.getActionListeners().length);
        UICommandTeedaTest.assertEquals(command1.getActionListeners().getClass(), command2.getActionListeners().getClass());
        UICommandTeedaTest.assertEquals(command1.getAction().getClass(), command2.getAction().getClass());
        UICommandTeedaTest.assertEquals(command1.getActionListener().getClass(), command2.getActionListener().getClass());
        UICommandTeedaTest.assertEquals((boolean)command1.isImmediate(), (boolean)command2.isImmediate());
        UICommandTeedaTest.assertEquals((Object)"bb", (Object)command2.getValue());
    }

    public void testDecode_SubmittedCommand() throws Exception {
        UICommand command = this.createUICommand();
        command.setId("aaa");
        MockFacesContext context = this.getFacesContext();
        context.getExternalContext().getRequestParameterMap().put("form:aaa", "xxx");
        UIViewRoot viewRoot = context.getViewRoot();
        command.setParent((UIComponent)viewRoot);
        ActionEvent ae = new ActionEvent((UIComponent)command);
        command.queueEvent((FacesEvent)ae);
        UICommandTeedaTest.assertEquals((Object)"aaa", context.getExternalContext().getRequestMap().get("teeda.SUBMITTED_COMMAND"));
    }

    private UICommand createUICommand() {
        return (UICommand)this.createUIComponent();
    }

    protected UIComponent createUIComponent() {
        return new UICommand();
    }
}

