/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.portlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.FactoryFinder;
import javax.faces.application.FacesMessage;
import javax.faces.application.StateManager;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.internal.WebAppUtil;
import javax.faces.internal.WindowIdUtil;
import javax.faces.internal.scope.PageScope;
import javax.faces.internal.scope.RedirectScope;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.ServletException;
import org.seasar.framework.log.Logger;
import org.seasar.teeda.core.portlet.FacesPortletState;
import org.seasar.teeda.core.util.DIContainerUtil;
import org.seasar.teeda.core.util.ErrorPageManager;
import org.seasar.teeda.core.util.NullErrorPageManagerImpl;
import org.seasar.teeda.core.util.PortletUtil;

public class FacesPortlet
extends GenericPortlet {
    private static final Logger logger = Logger.getLogger((Class)FacesPortlet.class);
    public static final String PORTLET_CONFIG = "javax.portlet.PortletConfig";
    public static final String VIEW_ID = FacesPortlet.class.getName() + ".VIEW_ID";
    public static final String DEFAULT_PAGE = FacesPortlet.class.getName() + ".DEFAULT_PAGE";
    public static final String DEFAULT_VIEW_PAGE = "view-page";
    public static final String DEFAULT_EDIT_PAGE = "edit-page";
    public static final String DEFAULT_HELP_PAGE = "help-page";
    public static final String FACES_PORTLET_STATE_PREFIX = FacesPortlet.class.getName() + ".FACES_PORTLET_STATE" + "-";
    public static final String PREVIOUS_PORTLET_MODE = FacesPortlet.class.getName() + ".PREVIOUS_PORTLET_MODE";
    public static final String CURRENT_PORTLET_MODE = FacesPortlet.class.getName() + ".CURRENT_PORTLET_MODE";
    public static final String EXCLUDED_ATTRIBUTE_LIST = FacesPortlet.class.getName() + ".EXCLUDED_ATTRIBUTE_LIST";
    public static final String REDEPLOYED_PORTLET = FacesPortlet.class.getName() + ".REDEPLOYED_PORTLET";
    public static final String RENDER_PARAMETER = FacesPortlet.class.getName() + ".RENDER_PARAMETER";
    protected FacesContextFactory facesContextFactory;
    protected Lifecycle lifecycle;
    private String defaultViewPage = null;
    private String defaultEditPage = null;
    private String defaultHelpPage = null;

    public void init() throws PortletException {
        super.init();
        this.defaultViewPage = this.getPortletConfig().getInitParameter(DEFAULT_VIEW_PAGE);
        this.defaultEditPage = this.getPortletConfig().getInitParameter(DEFAULT_EDIT_PAGE);
        this.defaultHelpPage = this.getPortletConfig().getInitParameter(DEFAULT_HELP_PAGE);
        if (null == this.defaultViewPage) {
            throw new PortletException("Portlet " + this.getPortletConfig().getPortletName() + " is incorrectly configured. No default View page is defined.");
        }
        if (null == this.defaultEditPage) {
            this.defaultEditPage = this.defaultViewPage;
        }
        if (null == this.defaultHelpPage) {
            this.defaultHelpPage = this.defaultViewPage;
        }
        try {
            this.facesContextFactory = (FacesContextFactory)WebAppUtil.getFactory("javax.faces.context.FacesContextFactory");
            LifecycleFactory lifecycleFactory = (LifecycleFactory)WebAppUtil.getFactory("javax.faces.lifecycle.LifecycleFactory");
            String lifecycleId = this.getLifecycleId(this.getPortletContext());
            this.lifecycle = lifecycleFactory.getLifecycle(lifecycleId);
        }
        catch (ServletException e) {
            throw new PortletException((Throwable)e);
        }
    }

    protected String getLifecycleId(PortletContext portletContext) {
        String lifecycleId = portletContext.getInitParameter("javax.faces.LIFECYCLE_ID");
        if (lifecycleId == null) {
            lifecycleId = "DEFAULT";
        }
        return lifecycleId;
    }

    public void destroy() {
        super.destroy();
        FactoryFinder.releaseFactories();
        this.facesContextFactory = null;
        this.lifecycle = null;
        this.defaultViewPage = null;
        this.defaultEditPage = null;
        this.defaultHelpPage = null;
    }

    protected void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.setContentType(request, response);
        this.setDefaultPage((PortletRequest)request, this.defaultEditPage);
        this.renderFaces(request, response);
    }

    protected void doHelp(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.setContentType(request, response);
        this.setDefaultPage((PortletRequest)request, this.defaultHelpPage);
        this.renderFaces(request, response);
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.setContentType(request, response);
        this.setDefaultPage((PortletRequest)request, this.defaultViewPage);
        this.renderFaces(request, response);
    }

    protected void setContentType(RenderRequest request, RenderResponse response) {
        if (response.getContentType() == null) {
            String portalPreferredContentType = request.getResponseContentType();
            if (portalPreferredContentType != null) {
                response.setContentType(portalPreferredContentType);
            } else {
                response.setContentType("text/html");
            }
        }
    }

    protected void setDefaultPage(PortletRequest request, String page) {
        if (request.getAttribute(DEFAULT_PAGE) == null) {
            request.setAttribute(DEFAULT_PAGE, (Object)page);
        }
    }

    private void storePortletConfig(PortletRequest request) {
        request.setAttribute(PORTLET_CONFIG, (Object)this.getPortletConfig());
    }

    private void setCurrentPortletMode(PortletRequest request) {
        request.setAttribute(CURRENT_PORTLET_MODE, (Object)request.getPortletMode().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void renderFaces(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        String redirectPath;
        block11: {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"called renderFaces..");
            }
            this.createExcludedAttributeList((PortletRequest)request);
            this.restoreErrorInfo((PortletRequest)request);
            this.storePortletConfig((PortletRequest)request);
            this.setCurrentPortletMode((PortletRequest)request);
            FacesContext facesContext = this.facesContextFactory.getFacesContext(this.getPortletContext(), request, response, this.lifecycle);
            request.setAttribute("facesContext", (Object)facesContext);
            redirectPath = null;
            try {
                try {
                    Map pageScope;
                    WindowIdUtil.setupWindowId(facesContext.getExternalContext());
                    Map map = pageScope = PageScope.getOrCreateContext(facesContext);
                    synchronized (map) {
                        this.restoreFacesState(facesContext);
                        this.lifecycle.render(facesContext);
                    }
                    this.saveFacesState(facesContext);
                }
                catch (Throwable e) {
                    this.handleException(facesContext, e);
                    Object var9_9 = null;
                    redirectPath = RedirectScope.getRedirectingPath(facesContext);
                    if (redirectPath != null) {
                        RedirectScope.removeContext(facesContext);
                    }
                    facesContext.release();
                    request.getPortletSession().setAttribute(PREVIOUS_PORTLET_MODE, (Object)request.getPortletMode().toString());
                    request.getPortletSession().setAttribute(REDEPLOYED_PORTLET, (Object)Boolean.FALSE);
                    break block11;
                }
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                redirectPath = RedirectScope.getRedirectingPath(facesContext);
                if (redirectPath != null) {
                    RedirectScope.removeContext(facesContext);
                }
                facesContext.release();
                request.getPortletSession().setAttribute(PREVIOUS_PORTLET_MODE, (Object)request.getPortletMode().toString());
                request.getPortletSession().setAttribute(REDEPLOYED_PORTLET, (Object)Boolean.FALSE);
                throw throwable;
            }
            redirectPath = RedirectScope.getRedirectingPath(facesContext);
            if (redirectPath != null) {
                RedirectScope.removeContext(facesContext);
            }
            facesContext.release();
            request.getPortletSession().setAttribute(PREVIOUS_PORTLET_MODE, (Object)request.getPortletMode().toString());
            request.getPortletSession().setAttribute(REDEPLOYED_PORTLET, (Object)Boolean.FALSE);
        }
        if (redirectPath != null) {
            this.redirectRenderFaces(request, response, redirectPath);
        }
        this.clearErrorInfo((PortletRequest)request);
    }

    protected void redirectRenderFaces(RenderRequest request, RenderResponse response, String viewId) throws PortletException, IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("called redirectRenderFaces.. viewId is " + viewId));
        }
        List excludedNameList = (List)request.getAttribute(EXCLUDED_ATTRIBUTE_LIST);
        Enumeration e = request.getAttributeNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (excludedNameList.contains(key)) continue;
            request.removeAttribute(key);
        }
        request.getPortletSession().removeAttribute(PREVIOUS_PORTLET_MODE);
        request.setAttribute(DEFAULT_PAGE, (Object)viewId);
        this.renderFaces(request, response);
    }

    protected void restoreFacesState(FacesContext facesContext) {
        Map sessionMap = facesContext.getExternalContext().getSessionMap();
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        String currentPortletMode = (String)requestMap.get(CURRENT_PORTLET_MODE);
        String previousPortletMode = (String)sessionMap.get(PREVIOUS_PORTLET_MODE);
        FacesPortletState state = null;
        if (previousPortletMode != null && previousPortletMode.equals(currentPortletMode)) {
            state = (FacesPortletState)sessionMap.get(FACES_PORTLET_STATE_PREFIX + currentPortletMode);
            if (state == null) {
                Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
                String viewId = (String)requestParameterMap.get(VIEW_ID);
                if (viewId != null && !this.checkSessionState(facesContext)) {
                    requestMap.put(VIEW_ID, viewId);
                }
                this.restoreView(facesContext);
                return;
            }
            String viewId = state.getViewId();
            requestMap.put(VIEW_ID, viewId);
            this.restoreView(facesContext);
            Iterator clientIds = state.getClientIds();
            while (clientIds.hasNext()) {
                String clientId = (String)clientIds.next();
                Iterator msgs = state.getMessages(clientId);
                while (msgs.hasNext()) {
                    facesContext.addMessage(clientId, (FacesMessage)msgs.next());
                }
            }
            this.copyMap(state.getRequestMap(), facesContext.getExternalContext().getRequestMap(), new ArrayList());
            Object s = state.getState();
            if (s != null) {
                facesContext.getViewRoot().processRestoreState(facesContext, s);
            }
        } else {
            this.restoreDefaultFacesState(facesContext);
        }
    }

    protected void restoreDefaultFacesState(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        Map requestMap = externalContext.getRequestMap();
        String viewId = (String)externalContext.getRequestMap().get(DEFAULT_PAGE);
        requestMap.put(VIEW_ID, viewId);
        Iterator i = externalContext.getSessionMap().entrySet().iterator();
        while (i.hasNext()) {
            String key;
            Map.Entry e = i.next();
            if (!(e.getKey() instanceof String) || !(key = (String)e.getKey()).startsWith(FACES_PORTLET_STATE_PREFIX)) continue;
            externalContext.getSessionMap().remove(key);
        }
        if (RedirectScope.isRedirecting(facesContext)) {
            RedirectScope.removeContext(facesContext);
        }
        this.restoreView(facesContext);
    }

    private void restoreView(FacesContext facesContext) {
        facesContext.renderResponse();
        this.lifecycle.execute(facesContext);
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"called processAction..");
        }
        if (this.checkSessionState((PortletRequest)request)) {
            return;
        }
        String viewId = request.getParameter(VIEW_ID);
        if (viewId != null) {
            request.setAttribute(VIEW_ID, (Object)viewId);
            this.executeFaces(request, response);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)"skip processAction because viewId is null.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void executeFaces(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        FacesContext facesContext;
        block19: {
            block17: {
                this.storePortletConfig((PortletRequest)request);
                this.setCurrentPortletMode((PortletRequest)request);
                this.createExcludedAttributeList((PortletRequest)request);
                facesContext = this.facesContextFactory.getFacesContext(this.getPortletContext(), request, response, this.lifecycle);
                try {
                    try {
                        Map pageScope;
                        WindowIdUtil.setupWindowId(facesContext.getExternalContext());
                        Map map = pageScope = PageScope.getOrCreateContext(facesContext);
                        synchronized (map) {
                            this.lifecycle.execute(facesContext);
                        }
                    }
                    catch (Throwable e) {
                        this.handleException(facesContext, e);
                        Object var8_8 = null;
                        if (!facesContext.getResponseComplete()) {
                            request.setAttribute(VIEW_ID, (Object)facesContext.getViewRoot().getViewId());
                            this.saveFacesState(facesContext);
                            if (request.getParameter(RENDER_PARAMETER) != null) {
                                this.setRenderParameters(request, response);
                            }
                        } else if (RedirectScope.isRedirecting(facesContext)) {
                            this.saveFacesState(facesContext);
                        }
                        facesContext.release();
                        return;
                    }
                    Object var8_7 = null;
                    if (facesContext.getResponseComplete()) break block17;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    if (!facesContext.getResponseComplete()) {
                        request.setAttribute(VIEW_ID, (Object)facesContext.getViewRoot().getViewId());
                        this.saveFacesState(facesContext);
                        if (request.getParameter(RENDER_PARAMETER) != null) {
                            this.setRenderParameters(request, response);
                        }
                    } else if (RedirectScope.isRedirecting(facesContext)) {
                        this.saveFacesState(facesContext);
                    }
                    facesContext.release();
                    throw throwable;
                }
                request.setAttribute(VIEW_ID, (Object)facesContext.getViewRoot().getViewId());
                this.saveFacesState(facesContext);
                if (request.getParameter(RENDER_PARAMETER) != null) {
                    this.setRenderParameters(request, response);
                }
                break block19;
            }
            if (RedirectScope.isRedirecting(facesContext)) {
                this.saveFacesState(facesContext);
            }
        }
        facesContext.release();
    }

    protected void saveFacesState(FacesContext facesContext) {
        String redirectPath;
        Map sessionMap = facesContext.getExternalContext().getSessionMap();
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        String currentPortletMode = (String)requestMap.get(CURRENT_PORTLET_MODE);
        sessionMap.put(PREVIOUS_PORTLET_MODE, currentPortletMode);
        FacesPortletState state = new FacesPortletState();
        if (!PortletUtil.isRender(facesContext)) {
            Iterator clientIds = facesContext.getClientIdsWithMessages();
            while (clientIds.hasNext()) {
                String clientId = (String)clientIds.next();
                Iterator msgs = facesContext.getMessages(clientId);
                while (msgs.hasNext()) {
                    state.addMessage(clientId, (FacesMessage)msgs.next());
                }
            }
        }
        if ((redirectPath = RedirectScope.getRedirectingPath(facesContext)) == null) {
            state.setViewId(facesContext.getViewRoot().getViewId());
            List excludedNameList = (List)requestMap.get(EXCLUDED_ATTRIBUTE_LIST);
            HashMap map = new HashMap();
            this.copyMap(requestMap, map, excludedNameList);
            state.setRequestMap(map);
            StateManager stateManager = facesContext.getApplication().getStateManager();
            stateManager.saveSerializedView(facesContext);
            state.setState(facesContext.getViewRoot().processSaveState(facesContext));
        } else {
            state.setViewId(redirectPath);
            HashMap map = new HashMap();
            state.setRequestMap(map);
            state.setState(null);
        }
        sessionMap.put(FACES_PORTLET_STATE_PREFIX + currentPortletMode, state);
    }

    protected void handleException(FacesContext context, Throwable e) throws PortletException, IOException {
        ExternalContext extContext;
        ErrorPageManager errorPageManager = null;
        try {
            errorPageManager = (ErrorPageManager)DIContainerUtil.getComponent(ErrorPageManager.class);
        }
        catch (Exception e1) {
            // empty catch block
        }
        if (errorPageManager == null) {
            errorPageManager = new NullErrorPageManagerImpl();
        }
        if (!errorPageManager.handleException(e, context, extContext = context.getExternalContext())) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof PortletException) {
                throw (PortletException)e;
            }
            if (e.getMessage() != null) {
                throw new PortletException(e.getMessage(), e);
            }
            throw new PortletException(e);
        }
        context.responseComplete();
    }

    protected boolean checkSessionState(PortletRequest request) {
        return request.getPortletSession(false) == null || request.getPortletSession().getAttribute(REDEPLOYED_PORTLET) == null;
    }

    protected boolean checkSessionState(FacesContext context) {
        return context.getExternalContext().getSession(false) == null || context.getExternalContext().getSessionMap().get(REDEPLOYED_PORTLET) == null;
    }

    protected void createExcludedAttributeList(PortletRequest request) {
        ArrayList excludedNameList = new ArrayList();
        Enumeration enu = request.getAttributeNames();
        while (enu.hasMoreElements()) {
            excludedNameList.add(enu.nextElement());
        }
        excludedNameList.add(EXCLUDED_ATTRIBUTE_LIST);
        excludedNameList.add("facesContext");
        request.setAttribute(EXCLUDED_ATTRIBUTE_LIST, excludedNameList);
    }

    private void copyMap(Map fromMap, Map toMap, List excludedNameList) {
        Iterator i = fromMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            if (toMap.containsKey((String)e.getKey()) || excludedNameList.contains((String)e.getKey())) continue;
            toMap.put(e.getKey(), e.getValue());
        }
    }

    protected void setRenderParameters(ActionRequest request, ActionResponse response) {
        Enumeration enu = request.getParameterNames();
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            response.setRenderParameter(key, request.getParameter(key));
        }
    }

    protected void restoreErrorInfo(PortletRequest request) {
        PortletSession portletSession = request.getPortletSession();
        Throwable exception = (Throwable)portletSession.getAttribute("teeda.jsf.error.exception");
        if (exception != null) {
            request.setAttribute("teeda.jsf.error.exception", (Object)exception);
            request.setAttribute("teeda.jsf.error.exception_type", exception.getClass());
            request.setAttribute("teeda.jsf.error.message", (Object)exception.getMessage());
        }
    }

    protected void clearErrorInfo(PortletRequest request) {
        request.getPortletSession().removeAttribute("teeda.jsf.error.exception");
    }
}

