/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.util;

import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.seasar.teeda.core.unit.TeedaTestCase;
import org.seasar.teeda.core.util.ServletErrorPageManagerImpl;

public class ServletErrorPageManagerImplTest
extends TeedaTestCase {
    public void testGetLocation_bySameException() throws Exception {
        ServletErrorPageManagerImpl manager = new ServletErrorPageManagerImpl();
        manager.addErrorPage(FooException.class, "a.jsp");
        ServletErrorPageManagerImplTest.assertEquals((String)"a.jsp", (String)manager.getLocation(FooException.class));
    }

    public void testGetLocation_bySuperClass() throws Exception {
        ServletErrorPageManagerImpl manager = new ServletErrorPageManagerImpl();
        manager.addErrorPage(HogeException.class, "b.jsp");
        ServletErrorPageManagerImplTest.assertEquals((String)"b.jsp", (String)manager.getLocation(FooException.class));
    }

    public void testGetLocation_notFound() throws Exception {
        ServletErrorPageManagerImpl manager = new ServletErrorPageManagerImpl();
        ServletErrorPageManagerImplTest.assertNull((Object)manager.getLocation(FooException.class));
    }

    public void testHandleException_locationNull() throws Exception {
        ServletErrorPageManagerImpl manager = new ServletErrorPageManagerImpl();
        ServletErrorPageManagerImplTest.assertFalse((boolean)manager.handleException((Throwable)new Exception(), (FacesContext)this.getFacesContext(), (ExternalContext)this.getExternalContext()));
    }

    public void testHandleException() throws Exception {
        ServletErrorPageManagerImpl manager = new ServletErrorPageManagerImpl();
        FooException e = new FooException();
        e.setMessage("aaa");
        manager.addErrorPage(e.getClass(), "a.jsp");
        ServletErrorPageManagerImplTest.assertTrue((boolean)manager.handleException((Throwable)e, (FacesContext)this.getFacesContext(), (ExternalContext)this.getExternalContext()));
        ServletErrorPageManagerImplTest.assertEquals((Object)e, (Object)this.getRequest().getAttribute("teeda.jsf.error.exception"));
        ServletErrorPageManagerImplTest.assertEquals(e.getClass(), (Object)this.getRequest().getAttribute("teeda.jsf.error.exception_type"));
        ServletErrorPageManagerImplTest.assertEquals((Object)"aaa", (Object)this.getRequest().getAttribute("teeda.jsf.error.message"));
    }

    private static class FooException
    extends HogeException {
        private static final long serialVersionUID = 1L;
        private String message_;

        private FooException() {
        }

        public void setMessage(String message) {
            this.message_ = message;
        }

        public String getMessage() {
            return this.message_;
        }
    }

    private static class HogeException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private HogeException() {
        }
    }
}

