/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html.support;

import java.util.Set;
import junit.framework.TestCase;
import org.seasar.teeda.core.render.html.support.UrlString;

public class UrlStringTest
extends TestCase {
    public void testParseAndGetParameter() throws Exception {
        UrlString url = new UrlString();
        url.parse("aaa?1=2&3=4");
        UrlStringTest.assertEquals((String)"aaa", (String)url.getPath());
        UrlStringTest.assertEquals((String)"2", (String)url.getParameter("1"));
        UrlStringTest.assertEquals((String)"4", (String)url.getParameter("3"));
        UrlStringTest.assertEquals(null, (String)url.getParameter("2"));
    }

    public void testGetParameterNames() throws Exception {
        UrlString url = new UrlString();
        url.parse("aaa?1=2&2=3&1=3");
        Set parameterNames = url.getParameterNames();
        UrlStringTest.assertEquals((int)2, (int)parameterNames.size());
        UrlStringTest.assertEquals((boolean)true, (boolean)parameterNames.contains("1"));
        UrlStringTest.assertEquals((boolean)true, (boolean)parameterNames.contains("2"));
        UrlStringTest.assertEquals((boolean)false, (boolean)parameterNames.contains("3"));
    }

    public void testParseAndGetParameters() throws Exception {
        UrlString url = new UrlString();
        url.parse("aaa?1=2&1=3");
        UrlStringTest.assertEquals((String)"aaa", (String)url.getPath());
        UrlStringTest.assertEquals((String)"2", (String)url.getParameter("1"));
        String[] values = url.getParameters("1");
        UrlStringTest.assertEquals((int)2, (int)values.length);
        UrlStringTest.assertEquals((String)"2", (String)values[0]);
        UrlStringTest.assertEquals((String)"3", (String)values[1]);
        UrlStringTest.assertEquals(null, (Object)url.getParameters("4"));
    }

    public void testIsIdentical_True1() throws Exception {
        UrlString url1 = new UrlString();
        url1.parse("aa");
        UrlString url2 = new UrlString();
        url2.parse("aa");
        UrlStringTest.assertEquals((boolean)true, (boolean)url1.isIdentical(url2));
    }

    public void testIsIdentical_True2() throws Exception {
        UrlString url1 = new UrlString();
        url1.parse("aa?1=2&b=c&1=2");
        UrlString url2 = new UrlString();
        url2.parse("aa?1=2&b=c&1=2");
        UrlStringTest.assertEquals((boolean)true, (boolean)url1.isIdentical(url2));
    }

    public void testIsIdentical_False1() throws Exception {
        UrlString url1 = new UrlString();
        url1.parse("ab");
        UrlString url2 = new UrlString();
        url2.parse("aa");
        UrlStringTest.assertEquals((boolean)false, (boolean)url1.isIdentical(url2));
    }

    public void testIsIdentical_False2() throws Exception {
        UrlString url1 = new UrlString();
        url1.parse("aa?1=2");
        UrlString url2 = new UrlString();
        url2.parse("aa?1=3");
        UrlStringTest.assertEquals((boolean)false, (boolean)url1.isIdentical(url2));
    }

    public void testIsIdentical_False3() throws Exception {
        UrlString url1 = new UrlString();
        url1.parse("aa?1=1&1=2&1=4");
        UrlString url2 = new UrlString();
        url2.parse("aa?1=1&1=3&1=4");
        UrlStringTest.assertEquals((boolean)false, (boolean)url1.isIdentical(url2));
    }

    public void testIsIdentical_False4() throws Exception {
        UrlString url1 = new UrlString();
        url1.parse("aa?1=1");
        UrlString url2 = new UrlString();
        url2.parse("aa?1=1&2=2");
        UrlStringTest.assertEquals((boolean)false, (boolean)url1.isIdentical(url2));
    }
}

