/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import java.net.URI;
import java.net.URISyntaxException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.ExternalContext;
import javax.faces.render.Renderer;
import javax.faces.render.RendererTest;
import javax.servlet.http.HttpServletRequest;
import org.custommonkey.xmlunit.Diff;
import org.seasar.framework.mock.servlet.MockHttpServletResponse;
import org.seasar.framework.mock.servlet.MockHttpServletResponseImpl;
import org.seasar.teeda.core.mock.MockExternalContext;
import org.seasar.teeda.core.mock.MockExternalContextImpl;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockHtmlOutputLink;
import org.seasar.teeda.core.mock.MockHtmlOutputText;
import org.seasar.teeda.core.render.html.HtmlOutputLinkRenderer;
import org.seasar.teeda.core.render.html.HtmlOutputTextRenderer;

public class HtmlOutputLinkRendererTest
extends RendererTest {
    private HtmlOutputLinkRenderer renderer;
    private MockHtmlOutputLink htmlOutputLink;
    private HtmlOutputTextRenderer textRenderer;

    protected void setUp() throws Exception {
        super.setUp();
        this.renderer = this.createHtmlOutputLinkRenderer();
        this.textRenderer = new HtmlOutputTextRenderer();
        this.htmlOutputLink = new MockHtmlOutputLink();
        this.htmlOutputLink.setRenderer((Renderer)this.renderer);
    }

    public void testEncode() throws Exception {
        this.htmlOutputLink.setValue("a");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlOutputLink);
        HtmlOutputLinkRendererTest.assertEquals((String)"<a href=\"a\"></a>", (String)this.getResponseText());
    }

    public void testEncode_CallsEncodeResourceUrl() throws Exception {
        this.htmlOutputLink.setValue("/abc.html");
        final String[] param = new String[]{null};
        MockFacesContext context = this.getFacesContext();
        context.setExternalContext((ExternalContext)new MockExternalContextImpl(){

            public String encodeResourceURL(String url) {
                param[0] = url;
                return url;
            }
        });
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlOutputLink);
        HtmlOutputLinkRendererTest.assertEquals((String)"/abc.html", (String)param[0]);
        HtmlOutputLinkRendererTest.assertEquals((String)"<a href=\"/abc.html\"></a>", (String)this.getResponseText());
    }

    public void testEncode_RenderFalse() throws Exception {
        this.htmlOutputLink.setRendered(false);
        this.htmlOutputLink.setValue("abc");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlOutputLink);
        HtmlOutputLinkRendererTest.assertEquals((String)"", (String)this.getResponseText());
    }

    public void testEncode_WithChild() throws Exception {
        MockHtmlOutputText child = new MockHtmlOutputText();
        child.setRenderer((Renderer)this.textRenderer);
        child.setValue("Y");
        this.htmlOutputLink.getChildren().add(child);
        this.htmlOutputLink.setValue("a");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlOutputLink);
        HtmlOutputLinkRendererTest.assertEquals((String)"<a href=\"a\">Y</a>", (String)this.getResponseText());
    }

    public void testEncode_WithAccesskey() throws Exception {
        this.htmlOutputLink.setValue("url");
        this.htmlOutputLink.setAccesskey("aa");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlOutputLink);
        HtmlOutputLinkRendererTest.assertEquals((String)"<a href=\"url\" accesskey=\"aa\"></a>", (String)this.getResponseText());
    }

    public void testEncode_WithId() throws Exception {
        this.htmlOutputLink.setId("someId");
        this.htmlOutputLink.setValue("url");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlOutputLink);
        HtmlOutputLinkRendererTest.assertEquals((String)"<a id=\"someId\" href=\"url\"></a>", (String)this.getResponseText());
    }

    public void testEncode_WithUnknownAttribute1() throws Exception {
        this.htmlOutputLink.setValue("url");
        this.htmlOutputLink.getAttributes().put("aa", "bb");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlOutputLink);
        HtmlOutputLinkRendererTest.assertEquals((String)"<a href=\"url\" aa=\"bb\"></a>", (String)this.getResponseText());
    }

    public void testEncode_WithUnknownAttribute2() throws Exception {
        this.htmlOutputLink.setValue("url");
        this.htmlOutputLink.getAttributes().put("a.a", "bb");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlOutputLink);
        HtmlOutputLinkRendererTest.assertEquals((String)"<a href=\"url\"></a>", (String)this.getResponseText());
    }

    public void testEncode_anchor1() throws Exception {
        this.htmlOutputLink.setValue("aaa.html#foo");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlOutputLink);
        HtmlOutputLinkRendererTest.assertEquals((String)"<a href=\"aaa.html#foo\"></a>", (String)this.getResponseText());
    }

    public void testEncode_anchor2() throws Exception {
        this.htmlOutputLink.setValue("aaa.html#foo");
        UIParameter param = new UIParameter();
        param.setName("a");
        param.setValue((Object)"b#c");
        this.htmlOutputLink.getChildren().add(param);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlOutputLink);
        HtmlOutputLinkRendererTest.assertEquals((String)"<a href=\"aaa.html?a=b%23c#foo\"></a>", (String)this.getResponseText());
    }

    public void testEncode_HrefIsJapanese() throws Exception {
        this.htmlOutputLink.setValue("/" + new Character('\u3042') + ".html");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlOutputLink);
        HtmlOutputLinkRendererTest.assertEquals((String)"<a href=\"/%E3%81%82.html\"></a>", (String)this.getResponseText());
    }

    public void testEncode_WithParam1() throws Exception {
        this.htmlOutputLink.setValue("url.html");
        UIParameter param = new UIParameter();
        param.setName("a");
        param.setValue((Object)"b");
        this.htmlOutputLink.getChildren().add(param);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlOutputLink);
        HtmlOutputLinkRendererTest.assertEquals((String)"<a href=\"url.html?a=b\"></a>", (String)this.getResponseText());
    }

    public void testEncode_WithParam2() throws Exception {
        this.htmlOutputLink.setValue("/a/b/url.html");
        UIParameter param = new UIParameter();
        param.setName("a");
        param.setValue((Object)"b/c");
        this.htmlOutputLink.getChildren().add(param);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlOutputLink);
        HtmlOutputLinkRendererTest.assertEquals((String)"<a href=\"/a/b/url.html?a=b%2Fc\"></a>", (String)this.getResponseText());
    }

    public void testEncode_BaseHrefHasQueryString() throws Exception {
        this.htmlOutputLink.setValue("url.html?1=2");
        UIParameter param = new UIParameter();
        param.setName("a");
        param.setValue((Object)"b");
        this.htmlOutputLink.getChildren().add(param);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlOutputLink);
        HtmlOutputLinkRendererTest.assertEquals((String)"<a href=\"url.html?1=2&amp;a=b\"></a>", (String)this.getResponseText());
    }

    public void testEncode_WithJapaneseParamValue() throws Exception {
        this.htmlOutputLink.setValue("url");
        UIParameter param = new UIParameter();
        param.setName("a");
        param.setValue((Object)new Character('\u3042'));
        this.htmlOutputLink.getChildren().add(param);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlOutputLink);
        HtmlOutputLinkRendererTest.assertEquals((String)"<a href=\"url?a=%E3%81%82\"></a>", (String)this.getResponseText());
    }

    public void testEncode_WithParams() throws Exception {
        this.htmlOutputLink.setValue("url");
        UIParameter param = new UIParameter();
        param.setName("a");
        param.setValue((Object)"1");
        this.htmlOutputLink.getChildren().add(param);
        param = new UIParameter();
        param.setName("b");
        param.setValue((Object)"2");
        this.htmlOutputLink.getChildren().add(param);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlOutputLink);
        HtmlOutputLinkRendererTest.assertEquals((String)"<a href=\"url?a=1&amp;b=2\"></a>", (String)this.getResponseText());
    }

    public void testEncode_WithAllAttributes() throws Exception {
        this.htmlOutputLink.setId("a");
        this.htmlOutputLink.setValue("b");
        this.htmlOutputLink.setAccesskey("c");
        this.htmlOutputLink.setCharset("d");
        this.htmlOutputLink.setCoords("e");
        this.htmlOutputLink.setDir("f");
        this.htmlOutputLink.setHreflang("g");
        this.htmlOutputLink.setLang("h");
        this.htmlOutputLink.setOnblur("i");
        this.htmlOutputLink.setOnclick("j");
        this.htmlOutputLink.setOndblclick("k");
        this.htmlOutputLink.setOnfocus("l");
        this.htmlOutputLink.setOnkeydown("m");
        this.htmlOutputLink.setOnkeypress("n");
        this.htmlOutputLink.setOnkeyup("o");
        this.htmlOutputLink.setOnmousedown("p");
        this.htmlOutputLink.setOnmousemove("q");
        this.htmlOutputLink.setOnmouseout("r");
        this.htmlOutputLink.setOnmouseover("s");
        this.htmlOutputLink.setOnmouseup("t");
        this.htmlOutputLink.setRel("u");
        this.htmlOutputLink.setRev("v");
        this.htmlOutputLink.setShape("w");
        this.htmlOutputLink.setStyle("u");
        this.htmlOutputLink.setStyleClass("x");
        this.htmlOutputLink.setTabindex("y");
        this.htmlOutputLink.setTarget("z");
        this.htmlOutputLink.setTitle("A");
        this.htmlOutputLink.setType("B");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlOutputLink);
        Diff diff = new Diff("<a id=\"a\" href=\"b?newwindow=true\" accesskey=\"c\" charset=\"d\" coords=\"e\" dir=\"f\" hreflang=\"g\" lang=\"h\" onblur=\"i\" onclick=\"j\" ondblclick=\"k\" onfocus=\"l\" onkeydown=\"m\" onkeypress=\"n\" onkeyup=\"o\" onmousedown=\"p\" onmousemove=\"q\" onmouseout=\"r\" onmouseover=\"s\" onmouseup=\"t\" rel=\"u\" rev=\"v\" shape=\"w\" style=\"u\" class=\"x\" tabindex=\"y\" target=\"z\" title=\"A\" type=\"B\"></a>", this.getResponseText());
        HtmlOutputLinkRendererTest.assertEquals((String)diff.toString(), (boolean)true, (boolean)diff.identical());
    }

    public void testEncode_WithoutCookie() throws Exception {
        this.htmlOutputLink.setValue("a");
        MockFacesContext facesContext = this.getFacesContext();
        MockExternalContext externalContext = (MockExternalContext)facesContext.getExternalContext();
        externalContext.setMockHttpServletResponse((MockHttpServletResponse)new MockHttpServletResponseImpl((HttpServletRequest)externalContext.getMockHttpServletRequest()){

            public String encodeURL(String url) {
                return url + ";jsessionid=HOGEHOGE";
            }
        });
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlOutputLink);
        HtmlOutputLinkRendererTest.assertEquals((String)"<a href=\"a;jsessionid=HOGEHOGE\"></a>", (String)this.getResponseText());
    }

    public void testGetRendersChildren() throws Exception {
        HtmlOutputLinkRendererTest.assertEquals((boolean)true, (boolean)this.renderer.getRendersChildren());
    }

    private HtmlOutputLinkRenderer createHtmlOutputLinkRenderer() {
        return (HtmlOutputLinkRenderer)this.createRenderer();
    }

    protected Renderer createRenderer() {
        HtmlOutputLinkRenderer renderer = new HtmlOutputLinkRenderer();
        renderer.setComponentIdLookupStrategy(this.getComponentIdLookupStrategy());
        return renderer;
    }

    public void testLearningURI() throws Exception {
        URI uri = new URI("aaa.html");
        HtmlOutputLinkRendererTest.assertEquals(null, (String)uri.getHost());
        HtmlOutputLinkRendererTest.assertEquals((String)"aaa.html", (String)uri.getPath());
        HtmlOutputLinkRendererTest.assertEquals(null, (String)uri.getFragment());
        HtmlOutputLinkRendererTest.assertEquals((int)-1, (int)uri.getPort());
        HtmlOutputLinkRendererTest.assertEquals(null, (String)uri.getAuthority());
        HtmlOutputLinkRendererTest.assertEquals(null, (String)uri.getScheme());
        HtmlOutputLinkRendererTest.assertEquals(null, (String)uri.getQuery());
        uri = new URI("http://teeda.seasar.org/ja/index.html#example");
        HtmlOutputLinkRendererTest.assertEquals((String)"teeda.seasar.org", (String)uri.getHost());
        HtmlOutputLinkRendererTest.assertEquals((String)"/ja/index.html", (String)uri.getPath());
        HtmlOutputLinkRendererTest.assertEquals((String)"example", (String)uri.getFragment());
        HtmlOutputLinkRendererTest.assertEquals((int)-1, (int)uri.getPort());
        HtmlOutputLinkRendererTest.assertEquals((String)"teeda.seasar.org", (String)uri.getAuthority());
        HtmlOutputLinkRendererTest.assertEquals((String)"http", (String)uri.getScheme());
        HtmlOutputLinkRendererTest.assertEquals(null, (String)uri.getQuery());
        uri = new URI("http://aaaa/ja/index.html#example");
        HtmlOutputLinkRendererTest.assertEquals((String)"aaaa", (String)uri.getHost());
        HtmlOutputLinkRendererTest.assertEquals((String)"/ja/index.html", (String)uri.getPath());
        HtmlOutputLinkRendererTest.assertEquals((String)"example", (String)uri.getFragment());
        HtmlOutputLinkRendererTest.assertEquals((int)-1, (int)uri.getPort());
        HtmlOutputLinkRendererTest.assertEquals((String)"aaaa", (String)uri.getAuthority());
        HtmlOutputLinkRendererTest.assertEquals((String)"http", (String)uri.getScheme());
        HtmlOutputLinkRendererTest.assertEquals(null, (String)uri.getQuery());
        try {
            new URI("a.html#example#aaa");
            HtmlOutputLinkRendererTest.fail();
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        uri = new URI("a.html?a=b&c=d#example");
        HtmlOutputLinkRendererTest.assertEquals((String)"example", (String)uri.getFragment());
        HtmlOutputLinkRendererTest.assertEquals((String)"a=b&c=d", (String)uri.getQuery());
        uri = new URI("a.html#example?a=b&c=d");
        HtmlOutputLinkRendererTest.assertEquals(null, (String)uri.getQuery());
        HtmlOutputLinkRendererTest.assertEquals((String)"example?a=b&c=d", (String)uri.getFragment());
        uri = new URI("http://\u3042\u3042\u3042/\u3044/\u3042.html");
        HtmlOutputLinkRendererTest.assertEquals((String)"/\u3044/\u3042.html", (String)uri.getPath());
    }

    public void testNewwindow() throws Exception {
        this.htmlOutputLink.setValue("url.html");
        this.htmlOutputLink.setTarget("_blank");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlOutputLink);
        HtmlOutputLinkRendererTest.assertEquals((String)"<a href=\"url.html?newwindow=true\" target=\"_blank\"></a>", (String)this.getResponseText());
    }
}

