/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.managedbean.impl;

import org.seasar.framework.container.ArgDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.InitMethodDef;
import org.seasar.framework.container.deployer.InstanceDefFactory;
import org.seasar.framework.container.impl.ArgDefImpl;
import org.seasar.framework.container.impl.ComponentDefImpl;
import org.seasar.framework.container.impl.InitMethodDefImpl;
import org.seasar.teeda.core.managedbean.ManagedBeanFactory;
import org.seasar.teeda.core.scope.Scope;
import org.seasar.teeda.core.unit.TeedaTestCase;

public class ManagedBeanFactoryImplTest
extends TeedaTestCase {
    private C c;

    public ManagedBeanFactoryImplTest(String arg0) {
        super(arg0);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testRegisterManagedBean() {
        ManagedBeanFactory factory = this.getManagedBeanFactory();
        factory.registerManagedBean("a", A.class, Scope.REQUEST);
        A a = (A)factory.getManagedBean("a");
        ManagedBeanFactoryImplTest.assertNotNull((Object)a);
        ManagedBeanFactoryImplTest.assertEquals((String)"hoge", (String)a.getStr());
    }

    public void testRegisterManagedBean2() {
        ManagedBeanFactory factory = this.getManagedBeanFactory();
        factory.registerManagedBean("a", A.class, Scope.REQUEST);
        factory.registerManagedBean("b", B.class, Scope.REQUEST);
        B b = (B)factory.getManagedBean("b");
        ManagedBeanFactoryImplTest.assertEquals((String)"hoge", (String)b.getString());
    }

    public void testRegisterManagedBean3() {
        ManagedBeanFactory factory = this.getManagedBeanFactory();
        factory.registerManagedBean("c", C.class, Scope.SESSION, "init", "destroy");
        this.c = (C)factory.getManagedBean("c");
        ManagedBeanFactoryImplTest.assertEquals((String)"init:", (String)this.c.toString());
    }

    protected void tearDownRegisterManagedBean3() throws Throwable {
        super.tearDownForEachTestMethod();
        ManagedBeanFactoryImplTest.assertEquals((String)"init:destroy", (String)this.c.toString());
    }

    public void testRegisterManagedBean4() throws Exception {
        ManagedBeanFactory factory = this.getManagedBeanFactory();
        factory.registerManagedBean("a", A.class, Scope.REQUEST);
        factory.registerManagedBean("b", A.class, Scope.REQUEST);
        A a = (A)factory.getManagedBean("b");
        ManagedBeanFactoryImplTest.assertEquals((String)"hoge", (String)a.getStr());
    }

    public void testRegisterManagedBean5() throws Exception {
        ManagedBeanFactory factory = this.getManagedBeanFactory();
        A a = new A();
        ComponentDefImpl cDef = new ComponentDefImpl(a.getClass());
        cDef.setComponentName("aaa");
        InitMethodDefImpl iDef = new InitMethodDefImpl("setStr");
        iDef.addArgDef((ArgDef)new ArgDefImpl((Object)"foo"));
        cDef.addInitMethodDef((InitMethodDef)iDef);
        factory.registerManagedBean((ComponentDef)cDef, Scope.REQUEST);
        A a2 = (A)factory.getManagedBean("aaa");
        ManagedBeanFactoryImplTest.assertEquals((String)"foo", (String)a2.getStr());
    }

    public void testManagedBeanScope_request() throws Exception {
        ManagedBeanFactory factory = this.getManagedBeanFactory();
        factory.registerManagedBean("A", A.class, Scope.REQUEST);
        ComponentDef cDef = this.getContainer().getComponentDef((Object)"A");
        ManagedBeanFactoryImplTest.assertEquals((Object)InstanceDefFactory.REQUEST, (Object)cDef.getInstanceDef());
    }

    public void testManagedBeanScope_session() throws Exception {
        ManagedBeanFactory factory = this.getManagedBeanFactory();
        factory.registerManagedBean("A", A.class, Scope.SESSION);
        ComponentDef cDef = this.getContainer().getComponentDef((Object)"A");
        ManagedBeanFactoryImplTest.assertEquals((Object)InstanceDefFactory.SESSION, (Object)cDef.getInstanceDef());
    }

    public void testManagedBeanScope_application() throws Exception {
        ManagedBeanFactory factory = this.getManagedBeanFactory();
        factory.registerManagedBean("A", A.class, Scope.APPLICATION);
        ComponentDef cDef = this.getContainer().getComponentDef((Object)"A");
        ManagedBeanFactoryImplTest.assertEquals((Object)InstanceDefFactory.APPLICATION, (Object)cDef.getInstanceDef());
    }

    public void testManagedBeanScope_none() throws Exception {
        ManagedBeanFactory factory = this.getManagedBeanFactory();
        factory.registerManagedBean("A", A.class, Scope.NONE);
        ComponentDef cDef = this.getContainer().getComponentDef((Object)"A");
        ManagedBeanFactoryImplTest.assertEquals((Object)InstanceDefFactory.OUTER, (Object)cDef.getInstanceDef());
    }

    public static class C {
        private String initName = "";
        private String destroyName = "";

        public void init() {
            this.initName = "init";
        }

        public void destroy() {
            this.destroyName = "destroy";
        }

        public String toString() {
            return this.initName + ":" + this.destroyName;
        }
    }

    public static class B {
        private A a_;

        public void setA(A a) {
            this.a_ = a;
        }

        public String getString() {
            return this.a_ != null ? this.a_.getStr() : null;
        }
    }

    public static class A {
        private String str = "hoge";

        public String getStr() {
            return this.str;
        }

        public void setStr(String str) {
            this.str = str;
        }
    }
}

