/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.config.faces.assembler.impl;

import javax.faces.application.Application;
import javax.faces.el.PropertyResolver;
import org.seasar.teeda.core.config.faces.assembler.impl.PropertyResolverAssembler;
import org.seasar.teeda.core.mock.MockPropertyResolver;
import org.seasar.teeda.core.mock.MockSingleConstructorPropertyResolver;
import org.seasar.teeda.core.unit.TeedaTestCase;

public class PropertyResolverAssemblerTest
extends TeedaTestCase {
    public PropertyResolverAssemblerTest(String name) {
        super(name);
    }

    public void testSimpleAssemblePropertyResolver() throws Exception {
        String resolverName = "org.seasar.teeda.core.mock.MockPropertyResolver";
        PropertyResolverAssembler assembler = new PropertyResolverAssembler(resolverName, (Application)this.getApplication());
        assembler.assemble();
        PropertyResolver resolver = this.getApplication().getPropertyResolver();
        PropertyResolverAssemblerTest.assertNotNull((Object)resolver);
        PropertyResolverAssemblerTest.assertTrue((boolean)(resolver instanceof MockPropertyResolver));
    }

    public void testMarshalAssemblePropertyResolver1() throws Exception {
        this.getApplication().setPropertyResolver((PropertyResolver)new MockPropertyResolver());
        String resolverName = "org.seasar.teeda.core.mock.MockSingleConstructorPropertyResolver";
        PropertyResolverAssembler assembler = new PropertyResolverAssembler(resolverName, (Application)this.getApplication());
        assembler.assemble();
        PropertyResolver resolver = this.getApplication().getPropertyResolver();
        PropertyResolverAssemblerTest.assertNotNull((Object)resolver);
        PropertyResolverAssemblerTest.assertTrue((boolean)(resolver instanceof MockSingleConstructorPropertyResolver));
        MockSingleConstructorPropertyResolver r = (MockSingleConstructorPropertyResolver)resolver;
        PropertyResolverAssemblerTest.assertTrue((boolean)(r.getOriginal() instanceof MockPropertyResolver));
    }
}

