/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.application.impl;

import javax.faces.component.UIComponent;
import junit.framework.TestCase;
import org.seasar.teeda.core.application.TreeStructure;
import org.seasar.teeda.core.application.impl.TreeStructureManagerImpl;
import org.seasar.teeda.core.mock.MockUIComponent;

public class TreeStructureManagerImplTest
extends TestCase {
    public void testBuildTreeStructure_simple() throws Exception {
        TreeStructureManagerImpl manager = new TreeStructureManagerImpl();
        MockUIComponent component = new MockUIComponent();
        component.setId("id");
        TreeStructure struct = manager.buildTreeStructure((UIComponent)component);
        TreeStructureManagerImplTest.assertEquals((String)component.getClass().getName(), (String)struct.getComponentClassName());
        TreeStructureManagerImplTest.assertEquals((String)"id", (String)struct.getComponentId());
    }

    public void testBuildTreeStructure_hasChildrenAndFacets() throws Exception {
        TreeStructureManagerImpl manager = new TreeStructureManagerImpl();
        MockUIComponent parent = new MockUIComponent();
        parent.setId("parent");
        MockUIComponent child1 = new MockUIComponent();
        child1.setId("child1");
        parent.getChildren().add(child1);
        MockUIComponent child2 = new MockUIComponent();
        child2.setId("child2");
        parent.getFacets().put("hoge", child2);
        TreeStructure struct = manager.buildTreeStructure((UIComponent)parent);
        TreeStructureManagerImplTest.assertEquals((String)parent.getClass().getName(), (String)struct.getComponentClassName());
        TreeStructureManagerImplTest.assertEquals((String)"parent", (String)struct.getComponentId());
        TreeStructure[] children = struct.getChildren();
        TreeStructureManagerImplTest.assertEquals((int)1, (int)children.length);
        TreeStructure childStruct = children[0];
        TreeStructureManagerImplTest.assertEquals((String)"child1", (String)childStruct.getComponentId());
        Object[] facets = struct.getFacets();
        TreeStructureManagerImplTest.assertEquals((int)1, (int)facets.length);
        Object[] childFacets = (Object[])facets[0];
        TreeStructureManagerImplTest.assertEquals((Object)"hoge", (Object)childFacets[0]);
        TreeStructureManagerImplTest.assertEquals((String)"child2", (String)((TreeStructure)childFacets[1]).getComponentId());
    }

    public void testBuildChildrenTreeStructure_simple() throws Exception {
        TreeStructureManagerImpl manager = new TreeStructureManagerImpl();
        MockUIComponent parent = new MockUIComponent();
        parent.setId("parent");
        MockUIComponent child = new MockUIComponent();
        child.setId("child");
        parent.getChildren().add(child);
        TreeStructure[] structs = manager.buildChildrenTreeStructure((UIComponent)parent);
        TreeStructureManagerImplTest.assertNotNull((Object)structs);
        TreeStructureManagerImplTest.assertTrue((structs.length == 1 ? 1 : 0) != 0);
        TreeStructure struct = structs[0];
        TreeStructureManagerImplTest.assertEquals((String)child.getClass().getName(), (String)struct.getComponentClassName());
        TreeStructureManagerImplTest.assertEquals((String)"child", (String)struct.getComponentId());
    }

    public void testBuildChildrenTreeStructure_null() throws Exception {
        TreeStructureManagerImpl manager = new TreeStructureManagerImpl();
        MockUIComponent parent = new MockUIComponent();
        parent.setId("parent");
        TreeStructure[] structs = manager.buildChildrenTreeStructure((UIComponent)parent);
        TreeStructureManagerImplTest.assertNull((Object)structs);
    }

    public void testBuildFacetsTreeStructure_simple() throws Exception {
        TreeStructureManagerImpl manager = new TreeStructureManagerImpl();
        MockUIComponent parent = new MockUIComponent();
        parent.setId("parent");
        MockUIComponent child = new MockUIComponent();
        child.setId("child");
        parent.getFacets().put("hoge", child);
        Object[] array = manager.buildFacetsTreeStructure((UIComponent)parent);
        TreeStructureManagerImplTest.assertNotNull((Object)array);
        TreeStructureManagerImplTest.assertTrue((array.length == 1 ? 1 : 0) != 0);
        Object[] objs = (Object[])array[0];
        TreeStructureManagerImplTest.assertEquals((String)"hoge", (String)objs[0].toString());
        TreeStructure struct = (TreeStructure)objs[1];
        TreeStructureManagerImplTest.assertEquals((String)child.getClass().getName(), (String)struct.getComponentClassName());
        TreeStructureManagerImplTest.assertEquals((String)"child", (String)struct.getComponentId());
    }

    public void testBuildFacetsTreeStructure_null() throws Exception {
        TreeStructureManagerImpl manager = new TreeStructureManagerImpl();
        MockUIComponent parent = new MockUIComponent();
        parent.setId("parent");
        Object[] array = manager.buildFacetsTreeStructure((UIComponent)parent);
        TreeStructureManagerImplTest.assertNull((Object)array);
    }

    public void testRestoreTreeStructure_simple() throws Exception {
        TreeStructureManagerImpl manager = new TreeStructureManagerImpl();
        TreeStructure struct = new TreeStructure(MockUIComponent.class.getName(), "id");
        UIComponent component = manager.restoreTreeStructure(struct);
        TreeStructureManagerImplTest.assertNotNull((Object)component);
        TreeStructureManagerImplTest.assertTrue((boolean)(component instanceof MockUIComponent));
        TreeStructureManagerImplTest.assertEquals((String)"id", (String)component.getId());
    }
}

