/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.internal;

import java.util.Iterator;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIInput;
import javax.faces.component.UIViewRoot;
import javax.faces.component.html.HtmlInputText;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.MethodNotFoundException;
import javax.faces.internal.FacesConfigOptions;
import javax.faces.internal.UIComponentUtil;
import javax.faces.internal.web.foo.FooPage;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.convention.impl.NamingConventionImpl;
import org.seasar.framework.util.ClassUtil;
import org.seasar.teeda.core.mock.MockUIComponentBase;
import org.seasar.teeda.core.unit.TeedaTestCase;

public class UIComponentUtilTest
extends TeedaTestCase {
    public void testIsDisabled() throws Exception {
        MockUIComponentBase component = new MockUIComponentBase();
        UIComponentUtilTest.assertEquals((boolean)false, (boolean)UIComponentUtil.isDisabled((UIComponent)component));
        component = new HtmlInputText();
        component.setDisabled(true);
        UIComponentUtilTest.assertEquals((boolean)true, (boolean)UIComponentUtil.isDisabled((UIComponent)component));
        component = new HtmlInputText();
        component.setDisabled(false);
        UIComponentUtilTest.assertEquals((boolean)false, (boolean)UIComponentUtil.isDisabled((UIComponent)component));
        component = new HtmlInputText();
        component.getAttributes().put("disabled", Boolean.TRUE);
        UIComponentUtilTest.assertEquals((boolean)true, (boolean)UIComponentUtil.isDisabled((UIComponent)component));
    }

    public void testGetStringAttribute() throws Exception {
        HtmlInputText component = new HtmlInputText();
        component.getAttributes().put("onblur", "aaaa");
        UIComponentUtilTest.assertEquals((String)"aaaa", (String)UIComponentUtil.getStringAttribute((UIComponent)component, (String)"onblur"));
    }

    public void testGetPrimitiveBooleanAttribute() throws Exception {
        HtmlInputText component = new HtmlInputText();
        component.getAttributes().put("readonly", Boolean.TRUE);
        UIComponentUtilTest.assertEquals((boolean)true, (boolean)UIComponentUtil.getPrimitiveBooleanAttribute((UIComponent)component, (String)"readonly"));
    }

    public void testGetPrimitiveIntAttribute() throws Exception {
        HtmlInputText component = new HtmlInputText();
        UIComponentUtilTest.assertEquals((int)Integer.MIN_VALUE, (int)UIComponentUtil.getPrimitiveIntAttribute((UIComponent)component, (String)"size"));
        component.setSize(321);
        UIComponentUtilTest.assertEquals((int)321, (int)UIComponentUtil.getPrimitiveIntAttribute((UIComponent)component, (String)"size"));
    }

    public void testGetLabel_labelReturned() {
        MockHtmlInputText component = new MockHtmlInputText();
        component.setId("aaa");
        component.setLabel("bbb");
        UIComponentUtilTest.assertEquals((String)"bbb", (String)UIComponentUtil.getLabel((UIComponent)component));
    }

    public void testGetLabel_labelProperties() {
        NamingConventionImpl nc = (NamingConventionImpl)this.getContainer().getComponent((Object)NamingConvention.class);
        nc.addRootPackageName(ClassUtil.getPackageName(((Object)((Object)this)).getClass()));
        this.register(FooPage.class, "foo_fooPage");
        FacesConfigOptions.setDefaultSuffix((String)".html");
        this.getFacesContext().getViewRoot().setViewId(nc.getViewRootPath() + "/foo/foo.html");
        MockHtmlInputText component = new MockHtmlInputText();
        component.setId("aaa");
        UIComponentUtilTest.assertEquals((String)"AAA", (String)UIComponentUtil.getLabel((UIComponent)component));
    }

    public void testGetLabel_idReturned() {
        NamingConventionImpl nc = (NamingConventionImpl)this.getContainer().getComponent((Object)NamingConvention.class);
        nc.addRootPackageName(ClassUtil.getPackageName(((Object)((Object)this)).getClass()));
        this.getFacesContext().getViewRoot().setViewId(nc.getViewRootPath() + "/foo/foo.html");
        FacesConfigOptions.setDefaultSuffix((String)".html");
        HtmlInputText component = new HtmlInputText();
        component.setId("xxx");
        UIComponentUtilTest.assertEquals((String)"xxx", (String)UIComponentUtil.getLabel((UIComponent)component));
    }

    public void testFindDescendant() {
        UIViewRoot root = new UIViewRoot();
        UIForm form = new UIForm();
        form.getChildren().add(new UIInput());
        root.getChildren().add(form);
        UICommand command = new UICommand();
        root.getChildren().add(command);
        UIComponentUtilTest.assertSame((Object)command, (Object)UIComponentUtil.findDescendant((UIComponent)root, (Class)UICommand.class));
    }

    public void testCollectDescendants() throws Exception {
        UIViewRoot root = new UIViewRoot();
        UIForm form = new UIForm();
        UIInput input = new UIInput();
        input.setId("a1");
        form.getChildren().add(input);
        UIInput input2 = new UIInput();
        input2.setId("a2");
        form.getChildren().add(input2);
        UIInput input3 = new UIInput();
        input3.setId("a3");
        form.getChildren().add(input3);
        root.getChildren().add(form);
        List list = UIComponentUtil.collectDescendants((UIComponent)root, (Class)UIInput.class);
        UIComponentUtilTest.assertNotNull((Object)list);
        UIComponentUtilTest.assertTrue((list.size() == 3 ? 1 : 0) != 0);
    }

    public void testCallValidators_justNormalValidatorCall() throws Exception {
        UIInput input = new UIInput();
        input.setId("aaa");
        final boolean[] call = new boolean[]{false};
        input.addValidator(new Validator(){

            public void validate(FacesContext context, UIComponent component, Object value) throws FacesException {
                call[0] = true;
                throw new ValidatorException(new FacesMessage(this){
                    private static final long serialVersionUID = 1L;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public String getSummary() {
                        return "hoge";
                    }
                });
            }
        });
        UIComponentUtil.callValidators((FacesContext)this.getFacesContext(), (UIInput)input, (Object)"123");
        UIComponentUtilTest.assertTrue((boolean)call[0]);
        Iterator messages = this.getFacesContext().getMessages();
        UIComponentUtilTest.assertNotNull((Object)messages);
        FacesMessage m = (FacesMessage)messages.next();
        UIComponentUtilTest.assertEquals((String)"hoge", (String)m.getSummary());
    }

    public void testCallValidators_methodValidatorCall0() throws Exception {
        UIInput input = new UIInput();
        input.setId("aaa");
        final boolean[] call = new boolean[]{false};
        input.setValidator(new MethodBinding(){

            public Class getType(FacesContext context) throws MethodNotFoundException {
                return null;
            }

            public Object invoke(FacesContext context, Object[] params) throws EvaluationException, MethodNotFoundException {
                call[0] = true;
                return null;
            }
        });
        UIComponentUtil.callValidators((FacesContext)this.getFacesContext(), (UIInput)input, (Object)"123");
        UIComponentUtilTest.assertTrue((boolean)call[0]);
    }

    public void testCallValidators_methodValidatorCall1() throws Exception {
        UIInput input = new UIInput();
        input.setId("aaa");
        final boolean[] call = new boolean[]{false};
        input.setValidator(new MethodBinding(){

            public Class getType(FacesContext context) throws MethodNotFoundException {
                return null;
            }

            public Object invoke(FacesContext context, Object[] params) throws EvaluationException, MethodNotFoundException {
                call[0] = true;
                ValidatorException e = new ValidatorException(new FacesMessage(this){
                    private static final long serialVersionUID = 1L;
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public String getSummary() {
                        return "hoge";
                    }
                });
                throw new EvaluationException((Throwable)e);
            }
        });
        UIComponentUtil.callValidators((FacesContext)this.getFacesContext(), (UIInput)input, (Object)"123");
        UIComponentUtilTest.assertTrue((boolean)call[0]);
        Iterator messages = this.getFacesContext().getMessages();
        UIComponentUtilTest.assertNotNull((Object)messages);
        FacesMessage m = (FacesMessage)messages.next();
        UIComponentUtilTest.assertEquals((String)"hoge", (String)m.getSummary());
    }

    public void testCallValidators_methodValidatorCall2() throws Exception {
        UIInput input = new UIInput();
        input.setId("aaa");
        final boolean[] call = new boolean[]{false};
        input.setValidator(new MethodBinding(){

            public Class getType(FacesContext context) throws MethodNotFoundException {
                return null;
            }

            public Object invoke(FacesContext context, Object[] params) throws EvaluationException, MethodNotFoundException {
                call[0] = true;
                throw new EvaluationException((Throwable)new Exception(this){
                    private final /* synthetic */ 6 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public String getMessage() {
                        return "aaa";
                    }
                });
            }
        });
        try {
            UIComponentUtil.callValidators((FacesContext)this.getFacesContext(), (UIInput)input, (Object)"123");
            UIComponentUtilTest.fail();
        }
        catch (EvaluationException expected) {
            UIComponentUtilTest.assertEquals((String)"aaa", (String)expected.getCause().getMessage());
            UIComponentUtilTest.success();
        }
    }

    public static class MockHtmlInputText
    extends HtmlInputText {
        private String label_;

        public String getLabel() {
            return this.label_;
        }

        public void setLabel(String label) {
            this.label_ = label;
        }
    }
}

