/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.convert;

import java.util.ArrayList;
import java.util.Locale;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.AbstractConverterTestCase;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.LongConverter;
import org.seasar.teeda.core.mock.MockUIComponent;

public class LongConverterTest
extends AbstractConverterTestCase {
    public void testGetAsObject_convertSuccess() throws Exception {
        Converter converter = this.createConverter();
        Object o = converter.getAsObject((FacesContext)this.getFacesContext(), (UIComponent)new MockUIComponent(), "12345678901234");
        LongConverterTest.assertNotNull((Object)o);
        Long l = (Long)o;
        LongConverterTest.assertEquals((long)12345678901234L, (long)l);
    }

    public void testGetAsObject_convertFail() throws Exception {
        Converter converter = this.createConverter();
        try {
            converter.getAsObject((FacesContext)this.getFacesContext(), (UIComponent)new MockUIComponent(), "aaa");
            LongConverterTest.fail();
        }
        catch (ConverterException expected) {
            LongConverterTest.success();
        }
    }

    public void testGetAsString_convertSuccess() throws Exception {
        Converter converter = this.createConverter();
        String value = converter.getAsString((FacesContext)this.getFacesContext(), (UIComponent)new MockUIComponent(), (Object)new Long(12345678901234L));
        LongConverterTest.assertEquals((String)"12345678901234", (String)value);
    }

    public void testGetAsString_convertFail() throws Exception {
        Converter converter = this.createConverter();
        try {
            converter.getAsString((FacesContext)this.getFacesContext(), (UIComponent)new MockUIComponent(), new ArrayList());
            LongConverterTest.fail();
        }
        catch (ConverterException expected) {
            LongConverterTest.success();
        }
    }

    public void testGetAsObject_convertWithDelimeter() throws Exception {
        Converter converter = this.createConverter();
        String value = "12,345,678,901,234";
        this.getFacesContext().getViewRoot().setLocale(Locale.JAPAN);
        Object o = converter.getAsObject((FacesContext)this.getFacesContext(), (UIComponent)new MockUIComponent(), value);
        LongConverterTest.assertNotNull((Object)o);
        Long l = (Long)o;
        LongConverterTest.assertEquals((long)12345678901234L, (long)l);
    }

    public void testConstants() throws Exception {
        LongConverterTest.assertEquals((String)"javax.faces.Long", (String)"javax.faces.Long");
    }

    protected Converter createConverter() {
        return this.createLongConverter();
    }

    protected LongConverter createLongConverter() {
        return new LongConverter();
    }
}

