/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.util.Map;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBaseTest;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.el.VariableResolver;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import junit.framework.Assert;
import junitx.framework.ObjectAssert;
import org.seasar.teeda.core.mock.MockDataModel;
import org.seasar.teeda.core.mock.MockFacesEvent;
import org.seasar.teeda.core.mock.MockUIComponent;
import org.seasar.teeda.core.mock.MockValueBinding;
import org.seasar.teeda.core.mock.MockVariableResolver;
import org.seasar.teeda.core.mock.NullFacesEvent;
import org.seasar.teeda.core.mock.NullUIComponent;
import org.seasar.teeda.core.unit.ExceptionAssert;

public class UIDataTest
extends UIComponentBaseTest {
    public final void testSetGetFirst() {
        UIData data = this.createUIData();
        data.setFirst(9);
        UIDataTest.assertEquals((int)9, (int)data.getFirst());
    }

    public final void testSetGetFirst_ValueBinding() {
        UIData data = this.createUIData();
        MockValueBinding vb = new MockValueBinding();
        vb.setValue((FacesContext)this.getFacesContext(), (Object)new Integer(10));
        data.setValueBinding("first", (ValueBinding)vb);
        UIDataTest.assertEquals((int)10, (int)data.getFirst());
    }

    public final void testSetGetFirst_Negative() {
        UIData data = this.createUIData();
        try {
            data.setFirst(-1);
            UIDataTest.fail();
        }
        catch (IllegalArgumentException iae) {
            ExceptionAssert.assertMessageExist(iae);
        }
    }

    public final void fixme_testSetGetFirst_ValueBinding_Negative() {
        UIData data = this.createUIData();
        MockValueBinding vb = new MockValueBinding();
        vb.setValue((FacesContext)this.getFacesContext(), (Object)new Integer(-10));
        try {
            data.setValueBinding("first", (ValueBinding)vb);
            System.out.println(data.getFirst());
            UIDataTest.fail();
        }
        catch (IllegalArgumentException iae) {
            ExceptionAssert.assertMessageExist(iae);
        }
    }

    public final void testSetGetFooter() {
        UIData data = this.createUIData();
        NullUIComponent component = new NullUIComponent();
        data.setFooter((UIComponent)component);
        UIDataTest.assertEquals((Object)((Object)component), (Object)data.getFooter());
        UIDataTest.assertEquals((Object)((Object)component), (Object)data.getFacet("footer"));
    }

    public final void testSetGetFooter_ValueBindingNotWork() {
        UIData data = this.createUIData();
        MockValueBinding vb = new MockValueBinding();
        NullUIComponent component = new NullUIComponent();
        vb.setValue((FacesContext)this.getFacesContext(), (Object)component);
        data.setValueBinding("footer", (ValueBinding)vb);
        UIDataTest.assertEquals(null, (Object)data.getFooter());
    }

    public final void testSetGetFooterByFacet() {
        UIData data = this.createUIData();
        NullUIComponent component = new NullUIComponent();
        data.getFacets().put("footer", component);
        UIDataTest.assertEquals((Object)((Object)component), (Object)data.getFooter());
        UIDataTest.assertEquals((Object)((Object)component), (Object)data.getFacet("footer"));
    }

    public final void testSetFooter_NullArg() {
        UIData data = this.createUIData();
        try {
            data.setFooter(null);
            UIDataTest.fail();
        }
        catch (NullPointerException npe) {
            ExceptionAssert.assertMessageExist(npe);
        }
    }

    public final void testSetGetHeader() {
        UIData data = this.createUIData();
        NullUIComponent component = new NullUIComponent();
        data.setHeader((UIComponent)component);
        UIDataTest.assertEquals((Object)((Object)component), (Object)data.getHeader());
        UIDataTest.assertEquals((Object)((Object)component), (Object)data.getFacet("header"));
    }

    public final void testSetGetHeader_ValueBindingNotWork() {
        UIData data = this.createUIData();
        MockValueBinding vb = new MockValueBinding();
        NullUIComponent component = new NullUIComponent();
        vb.setValue((FacesContext)this.getFacesContext(), (Object)component);
        data.setValueBinding("header", (ValueBinding)vb);
        UIDataTest.assertEquals(null, (Object)data.getHeader());
    }

    public final void testSetGetHeaderByFacet() {
        UIData data = this.createUIData();
        NullUIComponent component = new NullUIComponent();
        data.getFacets().put("header", component);
        UIDataTest.assertEquals((Object)((Object)component), (Object)data.getHeader());
        UIDataTest.assertEquals((Object)((Object)component), (Object)data.getFacet("header"));
    }

    public final void testSetHeader_NullArg() {
        UIData data = this.createUIData();
        try {
            data.setHeader(null);
            UIDataTest.fail();
        }
        catch (NullPointerException npe) {
            ExceptionAssert.assertMessageExist(npe);
        }
    }

    public void testIsRowAvailable() throws Exception {
        UIData data = this.createUIData();
        MockDataModel mockDataModel = new MockDataModel();
        data.setValue((Object)mockDataModel);
        mockDataModel.setRowAvailable(true);
        UIDataTest.assertEquals((boolean)true, (boolean)data.isRowAvailable());
        mockDataModel.setRowAvailable(false);
        UIDataTest.assertEquals((boolean)false, (boolean)data.isRowAvailable());
    }

    public void testGetRowCount() throws Exception {
        UIData data = this.createUIData();
        MockDataModel mockDataModel = new MockDataModel();
        mockDataModel.setRowCount(101);
        data.setValue((Object)mockDataModel);
        UIDataTest.assertEquals((int)101, (int)data.getRowCount());
    }

    public void testGetRowData() throws Exception {
        UIData data = this.createUIData();
        MockDataModel mockDataModel = new MockDataModel();
        mockDataModel.setRowData((Object)"abcd");
        data.setValue((Object)mockDataModel);
        UIDataTest.assertEquals((Object)"abcd", (Object)data.getRowData());
    }

    public void testSetGetRowIndex() throws Exception {
        UIData data = this.createUIData();
        MockDataModel dataModel = new MockDataModel();
        data.setValue((Object)dataModel);
        data.setRowIndex(19);
        UIDataTest.assertEquals((int)19, (int)data.getRowIndex());
        data.setRowIndex(1);
        UIDataTest.assertEquals((int)1, (int)data.getRowIndex());
    }

    public void testSetGetRowIndex_MinusOne() throws Exception {
        UIData data = this.createUIData();
        MockDataModel mockDataModel = new MockDataModel();
        data.setValue((Object)mockDataModel);
        data.setVar("varName");
        Map requestMap = this.getFacesContext().getExternalContext().getRequestMap();
        requestMap.put("varName", "fooo");
        data.setRowIndex(-1);
        UIDataTest.assertEquals(null, requestMap.get("varName"));
    }

    public void testSetGetRowIndex_UnderMinusOne() throws Exception {
        UIData data = this.createUIData();
        MockDataModel mockDataModel = new MockDataModel();
        data.setValue((Object)mockDataModel);
        try {
            data.setRowIndex(-2);
        }
        catch (IllegalArgumentException iae) {
            ExceptionAssert.assertMessageExist(iae);
        }
    }

    public void testSetGetRows() throws Exception {
        UIData data = this.createUIData();
        UIDataTest.assertEquals((int)0, (int)data.getRows());
        data.setRows(2);
        UIDataTest.assertEquals((int)2, (int)data.getRows());
        data.setRows(0);
        UIDataTest.assertEquals((int)0, (int)data.getRows());
    }

    public void testSetGetRows_Negative() throws Exception {
        UIData data = this.createUIData();
        try {
            data.setRows(-1);
            UIDataTest.fail();
        }
        catch (IllegalArgumentException iae) {
            ExceptionAssert.assertMessageExist(iae);
        }
    }

    public final void testSetGetVar() {
        UIData data = this.createUIData();
        data.setVar("aaa");
        UIDataTest.assertEquals((String)"aaa", (String)data.getVar());
    }

    public final void testSetGetValue() {
        UIData data = this.createUIData();
        data.setValue((Object)"abc");
        UIDataTest.assertEquals((Object)"abc", (Object)data.getValue());
    }

    public final void testSetGetValue_ValueBinding() {
        UIData data = this.createUIData();
        MockValueBinding vb = new MockValueBinding();
        vb.setValue((FacesContext)this.getFacesContext(), (Object)"some value");
        data.setValueBinding("value", (ValueBinding)vb);
        UIDataTest.assertEquals((Object)"some value", (Object)data.getValue());
    }

    public final void testSetValueBinding_IllegalArgId() {
        UIData data = this.createUIData();
        MockValueBinding vb = new MockValueBinding();
        vb.setValue((FacesContext)this.getFacesContext(), (Object)"a");
        try {
            data.setValueBinding("id", (ValueBinding)vb);
            UIDataTest.fail();
        }
        catch (IllegalArgumentException iae) {
            ExceptionAssert.assertMessageExist(iae);
        }
    }

    public final void testSetValueBinding_IllegalArgVar() {
        UIData data = this.createUIData();
        MockValueBinding vb = new MockValueBinding();
        vb.setValue((FacesContext)this.getFacesContext(), (Object)"a");
        try {
            data.setValueBinding("var", (ValueBinding)vb);
            UIDataTest.fail();
        }
        catch (IllegalArgumentException iae) {
            ExceptionAssert.assertMessageExist(iae);
        }
    }

    public final void testSetValueBinding_IllegalArgRowIndex() {
        UIData data = this.createUIData();
        MockValueBinding vb = new MockValueBinding();
        vb.setValue((FacesContext)this.getFacesContext(), (Object)"a");
        try {
            data.setValueBinding("rowIndex", (ValueBinding)vb);
            UIDataTest.fail();
        }
        catch (IllegalArgumentException iae) {
            ExceptionAssert.assertMessageExist(iae);
        }
    }

    public void testQueueEvent_WithParent() throws Exception {
        UIData data = this.createUIData();
        MockUIComponent parent = new MockUIComponent();
        data.setParent((UIComponent)parent);
        NullFacesEvent event = new NullFacesEvent();
        data.queueEvent((FacesEvent)event);
        FacesEvent queued = parent.getQueueEvent();
        ObjectAssert.assertInstanceOf((Class)UIData.FacesEventWrapper.class, (Object)queued);
        UIData.FacesEventWrapper wrapper = (UIData.FacesEventWrapper)queued;
        FacesEvent originalEvent = wrapper.getFacesEvent();
        UIDataTest.assertSame((Object)((Object)event), (Object)originalEvent);
    }

    public void testBroadcast_WrappedEvent() throws Exception {
        UIData data = this.createUIData();
        final boolean[] calls = new boolean[1];
        MockUIComponent source = new MockUIComponent(){

            public void broadcast(FacesEvent event) throws AbortProcessingException {
                calls[0] = true;
            }
        };
        MockFacesEvent originalEvent = new MockFacesEvent((UIComponent)source);
        data.broadcast((FacesEvent)new UIData.FacesEventWrapper((FacesEvent)originalEvent, 4, (UIComponent)new NullUIComponent()));
        UIDataTest.assertEquals((boolean)true, (boolean)calls[0]);
    }

    public void testProcessDecodes() throws Exception {
        final int[] calls = new int[]{0, 0, 0};
        final UIData data = this.createUIData();
        data.setValue((Object)new String[]{"A", "B", "C"});
        data.getFacets().put("f1", new MockUIComponent(){

            public void processDecodes(FacesContext context) {
                calls[0] = calls[0] + 1;
            }
        });
        UIColumn column = new UIColumn();
        column.getFacets().put("col1_f1", new MockUIComponent(){

            public void processDecodes(FacesContext context) {
                calls[1] = calls[1] + 1;
            }
        });
        column.getChildren().add(new MockUIComponent(){

            public void processDecodes(FacesContext context) {
                Assert.assertEquals((int)calls[2], (int)data.getRowIndex());
                calls[2] = calls[2] + 1;
            }
        });
        data.getChildren().add(column);
        data.setRendererType(null);
        UIDataTest.assertEquals((int)0, (int)data.getRowIndex());
        data.processDecodes((FacesContext)this.getFacesContext());
        UIDataTest.assertEquals((int)1, (int)calls[0]);
        UIDataTest.assertEquals((int)1, (int)calls[1]);
        UIDataTest.assertEquals((int)3, (int)calls[2]);
        UIDataTest.assertEquals((int)-1, (int)data.getRowIndex());
    }

    public void testProcessDecodes_RenderFalse() throws Exception {
        final int[] calls = new int[]{0, 0, 0};
        UIData data = this.createUIData();
        data.setRendered(false);
        data.setValue((Object)new String[]{"A", "B", "C"});
        data.getFacets().put("f1", new MockUIComponent(){

            public void processDecodes(FacesContext context) {
                calls[0] = calls[0] + 1;
            }
        });
        UIColumn column = new UIColumn();
        column.getFacets().put("col1_f1", new MockUIComponent(){

            public void processDecodes(FacesContext context) {
                calls[1] = calls[1] + 1;
            }
        });
        column.getChildren().add(new MockUIComponent(){

            public void processDecodes(FacesContext context) {
                calls[2] = calls[2] + 1;
            }
        });
        data.getChildren().add(column);
        data.setRendererType(null);
        UIDataTest.assertEquals((int)0, (int)data.getRowIndex());
        data.processDecodes((FacesContext)this.getFacesContext());
        UIDataTest.assertEquals((int)0, (int)calls[0]);
        UIDataTest.assertEquals((int)0, (int)calls[1]);
        UIDataTest.assertEquals((int)0, (int)calls[2]);
        UIDataTest.assertEquals((int)0, (int)data.getRowIndex());
    }

    public void testProcessValidators() throws Exception {
        final int[] calls = new int[]{0, 0, 0};
        final UIData data = this.createUIData();
        data.setValue((Object)new String[]{"A", "B", "C"});
        data.getFacets().put("f1", new MockUIComponent(){

            public void processValidators(FacesContext context) {
                calls[0] = calls[0] + 1;
            }
        });
        UIColumn column = new UIColumn();
        column.getFacets().put("col1_f1", new MockUIComponent(){

            public void processValidators(FacesContext context) {
                calls[1] = calls[1] + 1;
            }
        });
        column.getChildren().add(new MockUIComponent(){

            public void processValidators(FacesContext context) {
                Assert.assertEquals((int)calls[2], (int)data.getRowIndex());
                calls[2] = calls[2] + 1;
            }
        });
        data.getChildren().add(column);
        UIDataTest.assertEquals((int)0, (int)data.getRowIndex());
        data.processValidators((FacesContext)this.getFacesContext());
        UIDataTest.assertEquals((int)1, (int)calls[0]);
        UIDataTest.assertEquals((int)1, (int)calls[1]);
        UIDataTest.assertEquals((int)3, (int)calls[2]);
        UIDataTest.assertEquals((int)-1, (int)data.getRowIndex());
    }

    public void testProcessDecodes_CallFacetsAndChildren() throws Exception {
    }

    public void testProcessValidators_CallFacetsAndChildren() throws Exception {
    }

    public void testProcessUpdates_CallFacetsAndChildren() throws Exception {
    }

    public void testProcessValidators_RenderFalse() throws Exception {
        final int[] calls = new int[]{0, 0, 0};
        UIData data = this.createUIData();
        data.setRendered(false);
        data.setValue((Object)new String[]{"A", "B", "C"});
        data.getFacets().put("f1", new MockUIComponent(){

            public void processValidators(FacesContext context) {
                calls[0] = calls[0] + 1;
            }
        });
        UIColumn column = new UIColumn();
        column.getFacets().put("col1_f1", new MockUIComponent(){

            public void processValidators(FacesContext context) {
                calls[1] = calls[1] + 1;
            }
        });
        column.getChildren().add(new MockUIComponent(){

            public void processValidators(FacesContext context) {
                calls[2] = calls[2] + 1;
            }
        });
        data.getChildren().add(column);
        UIDataTest.assertEquals((int)0, (int)data.getRowIndex());
        data.processValidators((FacesContext)this.getFacesContext());
        UIDataTest.assertEquals((int)0, (int)calls[0]);
        UIDataTest.assertEquals((int)0, (int)calls[1]);
        UIDataTest.assertEquals((int)0, (int)calls[2]);
        UIDataTest.assertEquals((int)0, (int)data.getRowIndex());
    }

    public void testProcessUpdates() throws Exception {
        final int[] calls = new int[]{0, 0, 0};
        final UIData data = this.createUIData();
        data.setValue((Object)new String[]{"A", "B", "C"});
        data.getFacets().put("f1", new MockUIComponent(){

            public void processUpdates(FacesContext context) {
                calls[0] = calls[0] + 1;
            }
        });
        UIColumn column = new UIColumn();
        column.getFacets().put("col1_f1", new MockUIComponent(){

            public void processUpdates(FacesContext context) {
                calls[1] = calls[1] + 1;
            }
        });
        column.getChildren().add(new MockUIComponent(){

            public void processUpdates(FacesContext context) {
                Assert.assertEquals((int)calls[2], (int)data.getRowIndex());
                calls[2] = calls[2] + 1;
            }
        });
        data.getChildren().add(column);
        UIDataTest.assertEquals((int)0, (int)data.getRowIndex());
        data.processUpdates((FacesContext)this.getFacesContext());
        UIDataTest.assertEquals((int)1, (int)calls[0]);
        UIDataTest.assertEquals((int)1, (int)calls[1]);
        UIDataTest.assertEquals((int)3, (int)calls[2]);
        UIDataTest.assertEquals((int)-1, (int)data.getRowIndex());
    }

    public void testProcessUpdates_RenderFalse() throws Exception {
        final int[] callCount = new int[]{0, 0, 0};
        UIData data = this.createUIData();
        data.setRendered(false);
        data.setValue((Object)new String[]{"A", "B", "C"});
        data.getFacets().put("f1", new MockUIComponent(){

            public void processUpdates(FacesContext context) {
                callCount[0] = callCount[0] + 1;
            }
        });
        UIColumn column = new UIColumn();
        column.getFacets().put("col1_f1", new MockUIComponent(){

            public void processUpdates(FacesContext context) {
                callCount[1] = callCount[1] + 1;
            }
        });
        column.getChildren().add(new MockUIComponent(){

            public void processUpdates(FacesContext context) {
                callCount[2] = callCount[2] + 1;
            }
        });
        data.getChildren().add(column);
        data.processUpdates((FacesContext)this.getFacesContext());
        UIDataTest.assertEquals((int)0, (int)callCount[0]);
        UIDataTest.assertEquals((int)0, (int)callCount[1]);
        UIDataTest.assertEquals((int)0, (int)callCount[2]);
        UIDataTest.assertEquals((int)0, (int)data.getRowIndex());
    }

    private UIData createUIData() {
        return (UIData)this.createUIComponent();
    }

    protected UIComponent createUIComponent() {
        return new UIData();
    }

    protected void setUp() throws Exception {
        super.setUp();
        MockVariableResolver variableResolver = new MockVariableResolver();
        this.getFacesContext().getApplication().setVariableResolver((VariableResolver)variableResolver);
    }
}

