/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.util;

import java.util.NoSuchElementException;
import junit.framework.TestCase;
import org.seasar.teeda.core.unit.ExceptionAssert;
import org.seasar.teeda.core.util.LoopIterator;

public class LoopIteratorTest
extends TestCase {
    public void testNext() throws Exception {
        LoopIterator it = new LoopIterator((Object[])new String[]{"a", "bb", "ccc"});
        LoopIteratorTest.assertEquals((Object)"a", it.next());
        LoopIteratorTest.assertEquals((Object)"bb", it.next());
        LoopIteratorTest.assertEquals((Object)"ccc", it.next());
        LoopIteratorTest.assertEquals((Object)"a", it.next());
        LoopIteratorTest.assertEquals((Object)"bb", it.next());
        LoopIteratorTest.assertEquals((Object)"ccc", it.next());
        LoopIteratorTest.assertEquals((Object)"a", it.next());
    }

    public void testHasNext() throws Exception {
        LoopIterator it = new LoopIterator((Object[])new String[]{"a", "bb", "ccc"});
        LoopIteratorTest.assertEquals((boolean)true, (boolean)it.hasNext());
        LoopIteratorTest.assertEquals((boolean)true, (boolean)it.hasNext());
        LoopIteratorTest.assertEquals((boolean)true, (boolean)it.hasNext());
        LoopIteratorTest.assertEquals((boolean)true, (boolean)it.hasNext());
        LoopIteratorTest.assertEquals((boolean)true, (boolean)it.hasNext());
        LoopIteratorTest.assertEquals((boolean)true, (boolean)it.hasNext());
    }

    public void testNext_One() throws Exception {
        LoopIterator it = new LoopIterator((Object[])new String[]{"a"});
        LoopIteratorTest.assertEquals((Object)"a", it.next());
        LoopIteratorTest.assertEquals((Object)"a", it.next());
        LoopIteratorTest.assertEquals((Object)"a", it.next());
    }

    public void testHasNext_One() throws Exception {
        LoopIterator it = new LoopIterator((Object[])new String[]{"a"});
        LoopIteratorTest.assertEquals((boolean)true, (boolean)it.hasNext());
        LoopIteratorTest.assertEquals((boolean)true, (boolean)it.hasNext());
        LoopIteratorTest.assertEquals((boolean)true, (boolean)it.hasNext());
        LoopIteratorTest.assertEquals((boolean)true, (boolean)it.hasNext());
        LoopIteratorTest.assertEquals((boolean)true, (boolean)it.hasNext());
        LoopIteratorTest.assertEquals((boolean)true, (boolean)it.hasNext());
    }

    public void testHasNext_Empty() throws Exception {
        LoopIterator it = new LoopIterator((Object[])new String[0]);
        LoopIteratorTest.assertEquals((boolean)false, (boolean)it.hasNext());
        LoopIteratorTest.assertEquals((boolean)false, (boolean)it.hasNext());
        LoopIteratorTest.assertEquals((boolean)false, (boolean)it.hasNext());
        LoopIteratorTest.assertEquals((boolean)false, (boolean)it.hasNext());
    }

    public void testNext_Empty() throws Exception {
        LoopIterator it = new LoopIterator((Object[])new String[0]);
        try {
            it.next();
            LoopIteratorTest.fail();
        }
        catch (NoSuchElementException nsee) {
            ExceptionAssert.assertMessageExist(nsee);
        }
    }

    public void testConstructorWithNull() throws Exception {
        try {
            new LoopIterator(null);
            LoopIteratorTest.fail((String)"");
        }
        catch (NullPointerException npe) {
            ExceptionAssert.assertMessageExist(npe);
        }
    }
}

