/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.internal;

import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.internal.WindowIdEncodeUrlCustomizer;
import org.seasar.teeda.core.mock.MockExternalContext;
import org.seasar.teeda.core.unit.TeedaTestCase;

public class WindowIdEncodeUrlCustomizerTest
extends TeedaTestCase {
    public void testEncodeActionUrl() throws Exception {
        MockExternalContext externalContext = this.getExternalContext();
        Map requestMap = externalContext.getRequestMap();
        requestMap.put("wid", "123");
        WindowIdEncodeUrlCustomizer customizer = new WindowIdEncodeUrlCustomizer();
        String encodeActionUrl = customizer.encodeActionUrl((ExternalContext)externalContext, "http://foo.com/bar/baz.html");
        WindowIdEncodeUrlCustomizerTest.assertEquals((String)"http://foo.com/bar/baz.html?wid=123", (String)encodeActionUrl);
    }

    public void testEncodeActionUrl2() throws Exception {
        MockExternalContext externalContext = this.getExternalContext();
        Map requestMap = externalContext.getRequestMap();
        requestMap.put("wid", "123");
        WindowIdEncodeUrlCustomizer customizer = new WindowIdEncodeUrlCustomizer();
        String encodeActionUrl = customizer.encodeActionUrl((ExternalContext)externalContext, "http://foo.com/bar/baz.html?aaa=bbb");
        WindowIdEncodeUrlCustomizerTest.assertEquals((String)"http://foo.com/bar/baz.html?aaa=bbb&wid=123", (String)encodeActionUrl);
    }

    public void testEncodeActionUrl_noWindowId() throws Exception {
        MockExternalContext externalContext = this.getExternalContext();
        WindowIdEncodeUrlCustomizer customizer = new WindowIdEncodeUrlCustomizer();
        String encodeActionUrl = customizer.encodeActionUrl((ExternalContext)externalContext, "http://foo.com/bar/baz.html?aaa=bbb");
        WindowIdEncodeUrlCustomizerTest.assertEquals((String)"http://foo.com/bar/baz.html?aaa=bbb", (String)encodeActionUrl);
    }
}

