/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.convert;

import java.util.ArrayList;
import java.util.Locale;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.AbstractConverterTestCase;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.DoubleConverter;
import org.seasar.teeda.core.mock.MockUIComponent;

public class DoubleConverterTest
extends AbstractConverterTestCase {
    public void testGetAsObject_convertSuccess() throws Exception {
        Converter converter = this.createConverter();
        Object target = converter.getAsObject((FacesContext)this.getFacesContext(), (UIComponent)new MockUIComponent(), "2.834");
        DoubleConverterTest.assertNotNull((Object)target);
        DoubleConverterTest.assertTrue((boolean)(target instanceof Double));
        Double d = (Double)target;
        DoubleConverterTest.assertTrue((d == 2.834 ? 1 : 0) != 0);
    }

    public void testGetAsObject_convertFail() throws Exception {
        Converter converter = this.createConverter();
        try {
            converter.getAsObject((FacesContext)this.getFacesContext(), (UIComponent)new MockUIComponent(), "hoge");
            DoubleConverterTest.fail();
        }
        catch (ConverterException expected) {
            DoubleConverterTest.success();
        }
    }

    public void testGetAsString_convertSuccess() throws Exception {
        Converter converter = this.createConverter();
        String s = converter.getAsString((FacesContext)this.getFacesContext(), (UIComponent)new MockUIComponent(), (Object)new Double(1.234));
        DoubleConverterTest.assertEquals((String)"1.234", (String)s);
    }

    public void testGetAsString_convertFail() throws Exception {
        Converter converter = this.createConverter();
        try {
            converter.getAsString((FacesContext)this.getFacesContext(), (UIComponent)new MockUIComponent(), new ArrayList());
            DoubleConverterTest.fail();
        }
        catch (ConverterException expected) {
            DoubleConverterTest.success();
        }
    }

    public void testGetAsObject_convertWithDelimeter() throws Exception {
        Converter converter = this.createConverter();
        String value = "1,002.834";
        this.getFacesContext().getViewRoot().setLocale(Locale.JAPAN);
        Object target = converter.getAsObject((FacesContext)this.getFacesContext(), (UIComponent)new MockUIComponent(), value);
        DoubleConverterTest.assertNotNull((Object)target);
        DoubleConverterTest.assertTrue((boolean)(target instanceof Double));
        Double d = (Double)target;
        DoubleConverterTest.assertTrue((d == 1002.834 ? 1 : 0) != 0);
    }

    public void testConstants() throws Exception {
        DoubleConverterTest.assertEquals((String)"javax.faces.DoubleTime", (String)"javax.faces.DoubleTime");
    }

    protected Converter createConverter() {
        return this.createDoubleConverter();
    }

    protected DoubleConverter createDoubleConverter() {
        return new DoubleConverter();
    }
}

