/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.taglib.html;

import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlCommandButton;
import org.seasar.teeda.core.el.SimpleMethodBinding;
import org.seasar.teeda.core.exception.NoValueReferenceRuntimeException;
import org.seasar.teeda.core.mock.MockMethodBinding;
import org.seasar.teeda.core.taglib.html.CommandButtonTag;
import org.seasar.teeda.core.unit.TeedaTestCase;

public class CommandButtonTagTest
extends TeedaTestCase {
    public void testGetComponentType() throws Exception {
        CommandButtonTag tag = new CommandButtonTag();
        CommandButtonTagTest.assertEquals((String)"javax.faces.HtmlCommandButton", (String)tag.getComponentType());
    }

    public void testGetRenderType() throws Exception {
        CommandButtonTag tag = new CommandButtonTag();
        CommandButtonTagTest.assertEquals((String)"javax.faces.Button", (String)tag.getRendererType());
    }

    public void testSetProperties_All() throws Exception {
        HtmlCommandButton command = this.createHtmlCommandButton();
        CommandButtonTag tag = new CommandButtonTag();
        tag.setImmediate("false");
        tag.setImage("image");
        tag.setValue("value 1");
        tag.setAccesskey("access key");
        tag.setAlt("alt");
        tag.setDir("dir");
        tag.setDisabled("false");
        tag.setLang("lang");
        tag.setOnblur("onblur");
        tag.setOnchange("onchange");
        tag.setOnclick("onclick");
        tag.setOndblclick("ondblclick");
        tag.setOnfocus("onfocus");
        tag.setOnkeydown("onkeydown");
        tag.setOnkeypress("onkeypress");
        tag.setOnkeyup("onkeyup");
        tag.setOnmousedown("onmousedown");
        tag.setOnmousemove("onmousemove");
        tag.setOnmouseup("onmouseup");
        tag.setOnselect("onselect");
        tag.setReadonly("false");
        tag.setStyle("style");
        tag.setStyleClass("styleclass");
        tag.setTabindex("5");
        tag.setTitle("title");
        tag.setProperties((UIComponent)command);
        CommandButtonTagTest.assertFalse((boolean)command.isImmediate());
        CommandButtonTagTest.assertEquals((String)"image", (String)command.getImage());
        CommandButtonTagTest.assertEquals((Object)"value 1", (Object)command.getValue());
        CommandButtonTagTest.assertEquals((String)"access key", (String)command.getAccesskey());
        CommandButtonTagTest.assertEquals((String)"alt", (String)command.getAlt());
        CommandButtonTagTest.assertEquals((String)"dir", (String)command.getDir());
        CommandButtonTagTest.assertFalse((boolean)command.isDisabled());
        CommandButtonTagTest.assertEquals((String)"lang", (String)command.getLang());
        CommandButtonTagTest.assertEquals((String)"onblur", (String)command.getOnblur());
        CommandButtonTagTest.assertEquals((String)"onchange", (String)command.getOnchange());
        CommandButtonTagTest.assertEquals((String)"onclick", (String)command.getOnclick());
        CommandButtonTagTest.assertEquals((String)"ondblclick", (String)command.getOndblclick());
        CommandButtonTagTest.assertEquals((String)"onfocus", (String)command.getOnfocus());
        CommandButtonTagTest.assertEquals((String)"onkeydown", (String)command.getOnkeydown());
        CommandButtonTagTest.assertEquals((String)"onkeypress", (String)command.getOnkeypress());
        CommandButtonTagTest.assertEquals((String)"onkeyup", (String)command.getOnkeyup());
        CommandButtonTagTest.assertEquals((String)"onmousedown", (String)command.getOnmousedown());
        CommandButtonTagTest.assertEquals((String)"onmousemove", (String)command.getOnmousemove());
        CommandButtonTagTest.assertEquals((String)"onmouseup", (String)command.getOnmouseup());
        CommandButtonTagTest.assertEquals((String)"onselect", (String)command.getOnselect());
        CommandButtonTagTest.assertFalse((boolean)command.isReadonly());
        CommandButtonTagTest.assertEquals((String)"style", (String)command.getStyle());
        CommandButtonTagTest.assertEquals((String)"styleclass", (String)command.getStyleClass());
        CommandButtonTagTest.assertEquals((String)"5", (String)command.getTabindex());
        CommandButtonTagTest.assertEquals((String)"title", (String)command.getTitle());
    }

    public void testSetAction_constantValue() throws Exception {
        HtmlCommandButton command = this.createHtmlCommandButton();
        CommandButtonTag tag = new CommandButtonTag();
        tag.setAction("testAction");
        tag.setProperties((UIComponent)command);
        CommandButtonTagTest.assertTrue((boolean)(command.getAction() instanceof SimpleMethodBinding));
    }

    public void testSetAction_bindingValue() throws Exception {
        HtmlCommandButton command = this.createHtmlCommandButton();
        CommandButtonTag tag = new CommandButtonTag();
        tag.setAction("#{hoge.test}");
        tag.setProperties((UIComponent)command);
        CommandButtonTagTest.assertTrue((boolean)(command.getAction() instanceof MockMethodBinding));
    }

    public void testSetActionListener_noValue() throws Exception {
        HtmlCommandButton command = this.createHtmlCommandButton();
        CommandButtonTag tag = new CommandButtonTag();
        tag.setActionListener("testActionListener");
        try {
            tag.setProperties((UIComponent)command);
            CommandButtonTagTest.fail();
        }
        catch (NoValueReferenceRuntimeException e) {
            CommandButtonTagTest.success();
        }
    }

    public void testSetActionListener_bindingValue() throws Exception {
        HtmlCommandButton command = this.createHtmlCommandButton();
        CommandButtonTag tag = new CommandButtonTag();
        tag.setActionListener("#{hoge.do}");
        tag.setProperties((UIComponent)command);
        CommandButtonTagTest.assertTrue((boolean)(command.getActionListener() instanceof MockMethodBinding));
    }

    public void testRelease() throws Exception {
        CommandButtonTag tag = new CommandButtonTag();
        tag.setImmediate("false");
        tag.setActionListener("testActionListener");
        tag.setImage("image");
        tag.release();
        CommandButtonTagTest.assertEquals(null, (String)tag.getImmediate());
        CommandButtonTagTest.assertEquals(null, (String)tag.getImage());
        CommandButtonTagTest.assertEquals(null, (String)tag.getActionListener());
    }

    private HtmlCommandButton createHtmlCommandButton() {
        return (HtmlCommandButton)this.createUIComponent();
    }

    protected UIComponent createUIComponent() {
        return new HtmlCommandButton();
    }
}

