/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.taglib.core;

import java.util.Locale;
import java.util.TimeZone;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.DateTimeConverter;
import javax.faces.el.ValueBinding;
import javax.servlet.jsp.PageContext;
import org.seasar.teeda.core.mock.MockApplication;
import org.seasar.teeda.core.mock.MockApplicationImpl;
import org.seasar.teeda.core.mock.MockValueBinding;
import org.seasar.teeda.core.mock.NullPageContext;
import org.seasar.teeda.core.taglib.core.ConvertDateTimeTag;
import org.seasar.teeda.core.unit.TeedaTestCase;

public class ConvertDateTimeTagTest
extends TeedaTestCase {
    private MockApplication orgApp_;

    public void setupSetPageContext() {
        this.orgApp_ = this.getApplication();
    }

    public void testSetPageContext() throws Exception {
        String converterId = "javax.faces.DateTime";
        String converterClassName = "javax.faces.convert.DateTimeConverter";
        MockApplicationImpl app = new MockApplicationImpl();
        app.addConverter(converterId, converterClassName);
        this.setApplication((MockApplication)app);
        ConvertDateTimeTag tag = new ConvertDateTimeTag();
        tag.setPageContext((PageContext)new NullPageContext());
        Converter c = tag.createConverter();
        ConvertDateTimeTagTest.assertNotNull((Object)c);
        ConvertDateTimeTagTest.assertTrue((boolean)(c instanceof DateTimeConverter));
    }

    public void tearDownSetPageContext() {
        this.setApplication(this.orgApp_);
    }

    public void testSetConverterDateStyle_constantValue() throws Exception {
        DateTimeConverter c = new DateTimeConverter();
        ConvertDateTimeTag tag = new ConvertDateTimeTag();
        tag.setConverterDateStyle((FacesContext)this.getFacesContext(), c);
        ConvertDateTimeTagTest.assertEquals((String)"default", (String)c.getDateStyle());
    }

    public void testSetConverterDateStyle_bindingValue() throws Exception {
        MockValueBinding vb = new MockValueBinding();
        vb.setValue((FacesContext)this.getFacesContext(), (Object)"medium");
        this.getApplication().setValueBinding((ValueBinding)vb);
        DateTimeConverter c = new DateTimeConverter();
        ConvertDateTimeTag tag = new ConvertDateTimeTag();
        tag.setDateStyle("#{hoge.medium}");
        tag.setConverterDateStyle((FacesContext)this.getFacesContext(), c);
        ConvertDateTimeTagTest.assertEquals((String)"medium", (String)c.getDateStyle());
    }

    public void testSetConverterLocale_constantValue() throws Exception {
        DateTimeConverter c = new DateTimeConverter();
        ConvertDateTimeTag tag = new ConvertDateTimeTag();
        tag.setLocale(Locale.FRENCH.toString());
        tag.setConverterLocale((FacesContext)this.getFacesContext(), c);
        ConvertDateTimeTagTest.assertEquals((Object)Locale.FRENCH, (Object)c.getLocale());
    }

    public void testSetConverterLocale_bindingValue() throws Exception {
        MockValueBinding vb = new MockValueBinding();
        vb.setValue((FacesContext)this.getFacesContext(), (Object)Locale.GERMANY);
        this.getApplication().setValueBinding((ValueBinding)vb);
        DateTimeConverter c = new DateTimeConverter();
        ConvertDateTimeTag tag = new ConvertDateTimeTag();
        tag.setLocale("#{locale.getmany}");
        tag.setConverterLocale((FacesContext)this.getFacesContext(), c);
        ConvertDateTimeTagTest.assertEquals((Object)Locale.GERMANY, (Object)c.getLocale());
    }

    public void testSetConverterTimeZone_constantValue() throws Exception {
        DateTimeConverter c = new DateTimeConverter();
        ConvertDateTimeTag tag = new ConvertDateTimeTag();
        tag.setTimeZone("America/Los_Angeles");
        tag.setConverterTimeZone((FacesContext)this.getFacesContext(), c);
        ConvertDateTimeTagTest.assertEquals((Object)TimeZone.getTimeZone("America/Los_Angeles"), (Object)c.getTimeZone());
    }

    public void testSetConverterTimeZone_bindingValue() throws Exception {
        MockValueBinding vb = new MockValueBinding();
        vb.setValue((FacesContext)this.getFacesContext(), (Object)TimeZone.getTimeZone("Brazil/West"));
        this.getApplication().setValueBinding((ValueBinding)vb);
        DateTimeConverter c = new DateTimeConverter();
        ConvertDateTimeTag tag = new ConvertDateTimeTag();
        tag.setTimeZone("#{timeZone.a}");
        tag.setConverterTimeZone((FacesContext)this.getFacesContext(), c);
        ConvertDateTimeTagTest.assertEquals((Object)TimeZone.getTimeZone("Brazil/West"), (Object)c.getTimeZone());
    }

    public void setupCreateConverter() {
        this.orgApp_ = this.getApplication();
    }

    public void testCreateConverter() throws Exception {
        String converterId = "javax.faces.DateTime";
        String converterClassName = "javax.faces.convert.DateTimeConverter";
        MockApplicationImpl app = new MockApplicationImpl();
        app.addConverter(converterId, converterClassName);
        this.setApplication((MockApplication)app);
        ConvertDateTimeTag tag = new ConvertDateTimeTag();
        tag.setPageContext((PageContext)new NullPageContext());
        tag.setDateStyle("medium");
        tag.setLocale(Locale.JAPANESE.toString());
        tag.setPattern("pattern");
        tag.setTimeStyle("style");
        tag.setTimeZone("America/Los_Angeles");
        tag.setType("type");
        Converter c = tag.createConverter();
        ConvertDateTimeTagTest.assertNotNull((Object)c);
        ConvertDateTimeTagTest.assertTrue((boolean)(c instanceof DateTimeConverter));
        DateTimeConverter dc = (DateTimeConverter)c;
        ConvertDateTimeTagTest.assertEquals((String)"medium", (String)dc.getDateStyle());
        ConvertDateTimeTagTest.assertEquals((Object)Locale.JAPANESE, (Object)dc.getLocale());
        ConvertDateTimeTagTest.assertEquals((String)"pattern", (String)dc.getPattern());
        ConvertDateTimeTagTest.assertEquals((String)"style", (String)dc.getTimeStyle());
        ConvertDateTimeTagTest.assertEquals((Object)TimeZone.getTimeZone("America/Los_Angeles"), (Object)dc.getTimeZone());
        ConvertDateTimeTagTest.assertEquals((String)"type", (String)dc.getType());
    }

    public void tearDownCreateConverter() {
        this.setApplication(this.orgApp_);
    }

    public void testRelease() throws Exception {
        ConvertDateTimeTag tag = new ConvertDateTimeTag();
        tag.setDateStyle("medium");
        tag.setLocale(Locale.CANADA.toString());
        tag.setPattern("pattern");
        tag.setTimeStyle("style");
        tag.setTimeZone("America/Los_Angeles");
        tag.setType("type");
        tag.release();
        ConvertDateTimeTagTest.assertEquals((String)"default", (String)tag.getDateStyle());
        ConvertDateTimeTagTest.assertEquals(null, (String)tag.getLocale());
        ConvertDateTimeTagTest.assertEquals(null, (Object)tag.getParent());
        ConvertDateTimeTagTest.assertEquals((String)"default", (String)tag.getTimeStyle());
        ConvertDateTimeTagTest.assertEquals(null, (String)tag.getTimeZone());
        ConvertDateTimeTagTest.assertEquals((String)"default", (String)tag.getType());
    }
}

