/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import java.lang.reflect.Array;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.IntegerConverter;
import javax.faces.el.ValueBinding;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import javax.faces.render.Renderer;
import javax.faces.render.RendererTest;
import junitx.framework.ArrayAssert;
import org.custommonkey.xmlunit.Diff;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockHtmlSelectManyCheckbox;
import org.seasar.teeda.core.mock.MockValueBinding;
import org.seasar.teeda.core.render.html.HtmlSelectManyCheckboxRenderer;

public class HtmlSelectManyCheckboxRendererTest
extends RendererTest {
    private HtmlSelectManyCheckboxRenderer renderer;
    private MockHtmlSelectManyCheckbox htmlSelectManyCheckbox;

    protected void setUp() throws Exception {
        super.setUp();
        this.renderer = this.createHtmlSelectManyCheckboxRenderer();
        this.htmlSelectManyCheckbox = new MockHtmlSelectManyCheckbox();
        this.htmlSelectManyCheckbox.setRenderer((Renderer)this.renderer);
        this.renderer.addIgnoreAttributeName("setSubmittedValueCalls");
    }

    public void testEncode_NoChild() throws Exception {
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectManyCheckbox);
        HtmlSelectManyCheckboxRendererTest.assertEquals((String)"", (String)this.getResponseText());
    }

    public void testEncode_RenderFalse() throws Exception {
        this.htmlSelectManyCheckbox.setRendered(false);
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"val");
        selectItem.setItemLabel("lab");
        this.htmlSelectManyCheckbox.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectManyCheckbox);
        HtmlSelectManyCheckboxRendererTest.assertEquals((String)"", (String)this.getResponseText());
    }

    public void testEncode_Child() throws Exception {
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"val");
        selectItem.setItemLabel("lab");
        this.htmlSelectManyCheckbox.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectManyCheckbox);
        HtmlSelectManyCheckboxRendererTest.assertEquals((String)"<table><tr><td><label><input type=\"checkbox\" name=\"_id0\" value=\"val\" />lab</label></td></tr></table>", (String)this.getResponseText());
    }

    public void testEncode_Child_noneLayout() throws Exception {
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"val");
        selectItem.setItemLabel("lab");
        this.htmlSelectManyCheckbox.getChildren().add(selectItem);
        this.htmlSelectManyCheckbox.setLayout("none");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectManyCheckbox);
        HtmlSelectManyCheckboxRendererTest.assertEquals((String)"<label><input type=\"checkbox\" name=\"_id0\" value=\"val\" />lab</label>", (String)this.getResponseText());
    }

    public void testEncode_Id() throws Exception {
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"val");
        selectItem.setItemLabel("lab");
        this.htmlSelectManyCheckbox.getChildren().add(selectItem);
        this.htmlSelectManyCheckbox.setId("a");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectManyCheckbox);
        HtmlSelectManyCheckboxRendererTest.assertEquals((String)"<table id=\"a\"><tr><td><label><input type=\"checkbox\" name=\"a\" value=\"val\" />lab</label></td></tr></table>", (String)this.getResponseText());
    }

    public void testEncode_WithUnknownAttribute1() throws Exception {
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"val");
        selectItem.setItemLabel("lab");
        this.htmlSelectManyCheckbox.getChildren().add(selectItem);
        this.htmlSelectManyCheckbox.setId("a");
        this.htmlSelectManyCheckbox.getAttributes().put("aa", "bb");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectManyCheckbox);
        HtmlSelectManyCheckboxRendererTest.assertEquals((String)"<table id=\"a\"><tr><td><label><input type=\"checkbox\" name=\"a\" value=\"val\" aa=\"bb\" />lab</label></td></tr></table>", (String)this.getResponseText());
    }

    public void testEncode_WithUnknownAttribute2() throws Exception {
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"val");
        selectItem.setItemLabel("lab");
        this.htmlSelectManyCheckbox.getChildren().add(selectItem);
        this.htmlSelectManyCheckbox.setId("a");
        this.htmlSelectManyCheckbox.getAttributes().put("a.a", "bb");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectManyCheckbox);
        HtmlSelectManyCheckboxRendererTest.assertEquals((String)"<table id=\"a\"><tr><td><label><input type=\"checkbox\" name=\"a\" value=\"val\" />lab</label></td></tr></table>", (String)this.getResponseText());
    }

    public void testEncode_Children() throws Exception {
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v1");
        selectItem.setItemLabel("l1");
        this.htmlSelectManyCheckbox.getChildren().add(selectItem);
        selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v2");
        selectItem.setItemLabel("l2");
        this.htmlSelectManyCheckbox.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectManyCheckbox);
        HtmlSelectManyCheckboxRendererTest.assertEquals((String)"<table><tr><td><label><input type=\"checkbox\" name=\"_id0\" value=\"v1\" />l1</label></td><td><label><input type=\"checkbox\" name=\"_id0\" value=\"v2\" />l2</label></td></tr></table>", (String)this.getResponseText());
    }

    public void testEncode_Children_noneLayout() throws Exception {
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v1");
        selectItem.setItemLabel("l1");
        this.htmlSelectManyCheckbox.getChildren().add(selectItem);
        this.htmlSelectManyCheckbox.setLayout("none");
        selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v2");
        selectItem.setItemLabel("l2");
        this.htmlSelectManyCheckbox.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectManyCheckbox);
        HtmlSelectManyCheckboxRendererTest.assertEquals((String)"<label><input type=\"checkbox\" name=\"_id0\" value=\"v1\" />l1</label><label><input type=\"checkbox\" name=\"_id0\" value=\"v2\" />l2</label>", (String)this.getResponseText());
    }

    public void testEncode_Children_PageDirection() throws Exception {
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v1");
        selectItem.setItemLabel("l1");
        this.htmlSelectManyCheckbox.getChildren().add(selectItem);
        selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v2");
        selectItem.setItemLabel("l2");
        this.htmlSelectManyCheckbox.getChildren().add(selectItem);
        this.htmlSelectManyCheckbox.setLayout("pageDirection");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectManyCheckbox);
        HtmlSelectManyCheckboxRendererTest.assertEquals((String)"<table><tr><td><label><input type=\"checkbox\" name=\"_id0\" value=\"v1\" />l1</label></td></tr><tr><td><label><input type=\"checkbox\" name=\"_id0\" value=\"v2\" />l2</label></td></tr></table>", (String)this.getResponseText());
    }

    public void testEncode_Checked() throws Exception {
        this.htmlSelectManyCheckbox.setSelectedValues(new String[]{"val"});
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"val");
        selectItem.setItemLabel("lab");
        this.htmlSelectManyCheckbox.getChildren().add(selectItem);
        selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v2");
        selectItem.setItemLabel("l2");
        this.htmlSelectManyCheckbox.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectManyCheckbox);
        HtmlSelectManyCheckboxRendererTest.assertEquals((String)"<table><tr><td><label><input type=\"checkbox\" name=\"_id0\" value=\"val\" checked=\"checked\" />lab</label></td><td><label><input type=\"checkbox\" name=\"_id0\" value=\"v2\" />l2</label></td></tr></table>", (String)this.getResponseText());
    }

    public void testEncode_ItemDisabled() throws Exception {
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v1");
        selectItem.setItemLabel("l1");
        selectItem.setItemDisabled(true);
        this.htmlSelectManyCheckbox.getChildren().add(selectItem);
        selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v2");
        selectItem.setItemLabel("l2");
        this.htmlSelectManyCheckbox.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectManyCheckbox);
        HtmlSelectManyCheckboxRendererTest.assertEquals((String)"<table><tr><td><label><input type=\"checkbox\" name=\"_id0\" value=\"v1\" disabled=\"disabled\" />l1</label></td><td><label><input type=\"checkbox\" name=\"_id0\" value=\"v2\" />l2</label></td></tr></table>", (String)this.getResponseText());
    }

    public void testEncode_Disabled() throws Exception {
        this.htmlSelectManyCheckbox.setDisabled(true);
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v1");
        selectItem.setItemLabel("l1");
        this.htmlSelectManyCheckbox.getChildren().add(selectItem);
        selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v2");
        selectItem.setItemLabel("l2");
        this.htmlSelectManyCheckbox.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectManyCheckbox);
        HtmlSelectManyCheckboxRendererTest.assertEquals((String)"<table><tr><td><label><input type=\"checkbox\" name=\"_id0\" value=\"v1\" disabled=\"disabled\" />l1</label></td><td><label><input type=\"checkbox\" name=\"_id0\" value=\"v2\" disabled=\"disabled\" />l2</label></td></tr></table>", (String)this.getResponseText());
    }

    public void testEncode_LabelClass() throws Exception {
        this.htmlSelectManyCheckbox.setEnabledClass("ec");
        this.htmlSelectManyCheckbox.setDisabledClass("dc");
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v1");
        selectItem.setItemLabel("l1");
        this.htmlSelectManyCheckbox.getChildren().add(selectItem);
        selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v2");
        selectItem.setItemLabel("l2");
        selectItem.setItemDisabled(true);
        this.htmlSelectManyCheckbox.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectManyCheckbox);
        HtmlSelectManyCheckboxRendererTest.assertEquals((String)"<table><tr><td><label class=\"ec\"><input type=\"checkbox\" name=\"_id0\" value=\"v1\" />l1</label></td><td><label class=\"dc\"><input type=\"checkbox\" name=\"_id0\" value=\"v2\" disabled=\"disabled\" />l2</label></td></tr></table>", (String)this.getResponseText());
    }

    public void testEncode_GroupChildren() throws Exception {
        UISelectItems selectItems = new UISelectItems();
        SelectItem item1 = new SelectItem((Object)"v1", "l1");
        SelectItem item2 = new SelectItem((Object)"v2", "l2", null, true);
        selectItems.setValue((Object)new SelectItem[]{item1, item2});
        this.htmlSelectManyCheckbox.getChildren().add(selectItems);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectManyCheckbox);
        HtmlSelectManyCheckboxRendererTest.assertEquals((String)"<table><tr><td><label><input type=\"checkbox\" name=\"_id0\" value=\"v1\" />l1</label></td><td><label><input type=\"checkbox\" name=\"_id0\" value=\"v2\" disabled=\"disabled\" />l2</label></td></tr></table>", (String)this.getResponseText());
    }

    public void testEncode_NestedChildren() throws Exception {
        SelectItem item1 = new SelectItem((Object)"v1", "l1");
        SelectItem item2 = new SelectItem((Object)"v2", "l2", null, true);
        SelectItemGroup group = new SelectItemGroup("gl");
        group.setSelectItems(new SelectItem[]{item1, item2});
        UISelectItem selectItem = new UISelectItem();
        selectItem.setValue((Object)group);
        this.htmlSelectManyCheckbox.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectManyCheckbox);
        HtmlSelectManyCheckboxRendererTest.assertEquals((String)"<table><tr><td><table><tr><td><label><input type=\"checkbox\" name=\"_id0\" value=\"v1\" />l1</label></td><td><label><input type=\"checkbox\" name=\"_id0\" value=\"v2\" disabled=\"disabled\" />l2</label></td></tr></table></td></tr></table>", (String)this.getResponseText());
    }

    public void testEncode_WithAllAttributes() throws Exception {
        this.htmlSelectManyCheckbox.setAccesskey("a");
        this.htmlSelectManyCheckbox.setBorder(3);
        this.htmlSelectManyCheckbox.setDir("b");
        this.htmlSelectManyCheckbox.setDisabled(true);
        this.htmlSelectManyCheckbox.setDisabledClass("d");
        this.htmlSelectManyCheckbox.setEnabledClass("e");
        this.htmlSelectManyCheckbox.setLang("f");
        this.htmlSelectManyCheckbox.setOnblur("g");
        this.htmlSelectManyCheckbox.setOnchange("h");
        this.htmlSelectManyCheckbox.setOnclick("i");
        this.htmlSelectManyCheckbox.setOndblclick("j");
        this.htmlSelectManyCheckbox.setOnfocus("k");
        this.htmlSelectManyCheckbox.setOnkeydown("l");
        this.htmlSelectManyCheckbox.setOnkeypress("m");
        this.htmlSelectManyCheckbox.setOnkeyup("n");
        this.htmlSelectManyCheckbox.setOnmousedown("o");
        this.htmlSelectManyCheckbox.setOnmousemove("p");
        this.htmlSelectManyCheckbox.setOnmouseout("q");
        this.htmlSelectManyCheckbox.setOnmouseover("r");
        this.htmlSelectManyCheckbox.setOnmouseup("s");
        this.htmlSelectManyCheckbox.setOnselect("t");
        this.htmlSelectManyCheckbox.setReadonly(true);
        this.htmlSelectManyCheckbox.setStyle("w");
        this.htmlSelectManyCheckbox.setStyleClass("u");
        this.htmlSelectManyCheckbox.setTabindex("x");
        this.htmlSelectManyCheckbox.setTitle("y");
        this.htmlSelectManyCheckbox.getAttributes().put("type", "checkbox");
        this.htmlSelectManyCheckbox.getAttributes().put("checked", "checked");
        this.htmlSelectManyCheckbox.setId("A");
        this.htmlSelectManyCheckbox.setValue(new String[]{"val"});
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"val");
        selectItem.setItemLabel("lab");
        this.htmlSelectManyCheckbox.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectManyCheckbox);
        Diff diff = new Diff("<table id=\"A\" border=\"3\" style=\"w\" class=\"u\"><tr><td><label class=\"d\"><input type=\"checkbox\" name=\"A\" value=\"val\" checked=\"checked\" accesskey=\"a\" dir=\"b\" disabled=\"disabled\" lang=\"f\" onblur=\"g\" onchange=\"h\" onclick=\"i\" ondblclick=\"j\" onfocus=\"k\" onkeydown=\"l\" onkeypress=\"m\" onkeyup=\"n\" onmousedown=\"o\" onmousemove=\"p\" onmouseout=\"q\" onmouseover=\"r\" onmouseup=\"s\" onselect=\"t\" readonly=\"readonly\" tabindex=\"x\" title=\"y\"/>lab</label></td></tr></table>", this.getResponseText());
        HtmlSelectManyCheckboxRendererTest.assertEquals((String)diff.toString(), (boolean)true, (boolean)diff.identical());
    }

    public void testDecode_RequestParameterNotExist() throws Exception {
        this.htmlSelectManyCheckbox.setClientId("key");
        MockFacesContext context = this.getFacesContext();
        this.renderer.decode((FacesContext)context, (UIComponent)this.htmlSelectManyCheckbox);
        HtmlSelectManyCheckboxRendererTest.assertEquals((int)1, (int)this.htmlSelectManyCheckbox.getSetSubmittedValueCalls());
        String[] submittedValue = (String[])this.htmlSelectManyCheckbox.getSubmittedValue();
        HtmlSelectManyCheckboxRendererTest.assertEquals((int)0, (int)submittedValue.length);
    }

    public void testDecodeSuccess() throws Exception {
        this.htmlSelectManyCheckbox.setClientId("keyA");
        MockFacesContext context = this.getFacesContext();
        context.getExternalContext().getRequestParameterValuesMap().put("keyA", new String[]{"a", "b", "c"});
        this.renderer.decode((FacesContext)context, (UIComponent)this.htmlSelectManyCheckbox);
        HtmlSelectManyCheckboxRendererTest.assertEquals((int)1, (int)this.htmlSelectManyCheckbox.getSetSubmittedValueCalls());
        ArrayAssert.assertEquivalenceArrays((Object[])new String[]{"a", "b", "c"}, (Object[])((Object[])this.htmlSelectManyCheckbox.getSubmittedValue()));
    }

    public void testGetRendersChildren() throws Exception {
        HtmlSelectManyCheckboxRendererTest.assertEquals((boolean)false, (boolean)this.renderer.getRendersChildren());
    }

    public void testGetConvertedValue() throws Exception {
        UIOutput out = new UIOutput();
        out.setConverter((Converter)new IntegerConverter());
        MockValueBinding vb = new MockValueBinding();
        vb.setType([I.class);
        out.setValueBinding("value", (ValueBinding)vb);
        Object submittedValue = Array.newInstance(String.class, 3);
        Array.set(submittedValue, 0, "1");
        Array.set(submittedValue, 1, "2");
        Array.set(submittedValue, 2, "3");
        Object o = this.renderer.getConvertedValue((FacesContext)this.getFacesContext(), (UIComponent)out, submittedValue);
        int[] result = (int[])o;
        HtmlSelectManyCheckboxRendererTest.assertEquals((int)3, (int)result.length);
        ArrayAssert.assertEquals((int[])new int[]{1, 2, 3}, (int[])result);
    }

    private HtmlSelectManyCheckboxRenderer createHtmlSelectManyCheckboxRenderer() {
        return (HtmlSelectManyCheckboxRenderer)this.createRenderer();
    }

    protected Renderer createRenderer() {
        HtmlSelectManyCheckboxRenderer renderer = new HtmlSelectManyCheckboxRenderer();
        renderer.setComponentIdLookupStrategy(this.getComponentIdLookupStrategy());
        return renderer;
    }
}

