/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.el.impl;

import junit.framework.TestCase;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.teeda.core.el.impl.JspELParserUtil;

public class JspELParserUtilTest
extends TestCase {
    public void testConvertToJspExpression0() {
        try {
            JspELParserUtil.convertToJspExpression(null);
            JspELParserUtilTest.fail();
        }
        catch (EmptyRuntimeException e) {
            JspELParserUtilTest.assertTrue((boolean)true);
        }
    }

    public void testConvertToJspExpression1() {
        JspELParserUtilTest.assertEquals((String)"1", (String)"${}", (String)JspELParserUtil.convertToJspExpression((String)"#{}"));
    }

    public void testConvertToJspExpression2() {
        JspELParserUtilTest.assertEquals((String)"2", (String)"{}", (String)JspELParserUtil.convertToJspExpression((String)"{}"));
    }

    public void testConvertToJspExpression3() {
        JspELParserUtilTest.assertEquals((String)"3", (String)"{aa} {bb}", (String)JspELParserUtil.convertToJspExpression((String)"{aa} {bb}"));
    }

    public void testConvertToJspExpression4() {
        JspELParserUtilTest.assertEquals((String)"4", (String)"{aa}{bb}", (String)JspELParserUtil.convertToJspExpression((String)"{aa}{bb}"));
    }

    public void testConvertToJspExpression5() {
        JspELParserUtilTest.assertEquals((String)"5", (String)"1${'<'}{0,number,integer}", (String)JspELParserUtil.convertToJspExpression((String)"1#{'<'}{0,number,integer}"));
    }

    public void testConvertToJspExpression6() {
        JspELParserUtilTest.assertEquals((String)"6", (String)"{0,choice,0#${scrollerNoItem_}|1#${scrollerOneItem_}|1${'<'}{0,number,integer} ${scrollerItems_}} ${dataScrollerMsg.found_displaying} {1} to {2}. ${dataScrollerMsg.Page} {3} / {4}", (String)JspELParserUtil.convertToJspExpression((String)"{0,choice,0##{scrollerNoItem_}|1##{scrollerOneItem_}|1#{'<'}{0,number,integer} #{scrollerItems_}} #{dataScrollerMsg.found_displaying} {1} to {2}. #{dataScrollerMsg.Page} {3} / {4}"));
    }

    public void testConvertToJspExpression7() {
        JspELParserUtilTest.assertEquals((String)"7", (String)"${foo}", (String)JspELParserUtil.convertToJspExpression((String)"#{foo}"));
    }

    public void testConvertToJspExpression8() {
        JspELParserUtilTest.assertEquals((String)"8", (String)"${#{foo}}", (String)JspELParserUtil.convertToJspExpression((String)"#{#{foo}}"));
    }

    public void testConvertToJspExpression9() {
        JspELParserUtilTest.assertEquals((String)"9", (String)"foo${foo}bar", (String)JspELParserUtil.convertToJspExpression((String)"foo#{foo}bar"));
    }

    public void testConvertToJspExpression10() {
        JspELParserUtilTest.assertEquals((String)"10", (String)"foo\\${foo}", (String)JspELParserUtil.convertToJspExpression((String)"foo\\#{foo}"));
    }

    public void testConvertToJspExpression11() {
        JspELParserUtilTest.assertEquals((String)"11", (String)"foo${foo = '#{foo}'}", (String)JspELParserUtil.convertToJspExpression((String)"foo#{foo = '#{foo}'}"));
    }

    public void testConvertToJspExpression12() {
        JspELParserUtilTest.assertEquals((String)"12", (String)"foo${foo = '\\'#{foo}'}", (String)JspELParserUtil.convertToJspExpression((String)"foo#{foo = '\\'#{foo}'}"));
    }

    public void testConvertToJspExpression13() {
        JspELParserUtilTest.assertEquals((String)"13", (String)"foo${foo = \"\\\"#{foo}\"}", (String)JspELParserUtil.convertToJspExpression((String)"foo#{foo = \"\\\"#{foo}\"}"));
    }

    public void testConvertToJspExpression14() {
        JspELParserUtilTest.assertEquals((String)"14", (String)"foo's${bar}", (String)JspELParserUtil.convertToJspExpression((String)"foo's#{bar}"));
    }

    public void testConvertToJspExpression15() {
        JspELParserUtilTest.assertEquals((String)"15", (String)"foo${bar}${baz}", (String)JspELParserUtil.convertToJspExpression((String)"foo#{bar}#{baz}"));
    }

    public void testConvertToJspExpression16() {
        JspELParserUtilTest.assertEquals((String)"16", (String)"foo${bar}{baz}", (String)JspELParserUtil.convertToJspExpression((String)"foo#{bar}{baz}"));
    }

    public void testConvertToJspExpression17() {
        JspELParserUtilTest.assertEquals((String)"17", (String)"foo${'}'}", (String)JspELParserUtil.convertToJspExpression((String)"foo#{'}'}"));
    }

    public void testConvertToJspExpression18() {
        JspELParserUtilTest.assertEquals((String)"18", (String)"foo${bar'}", (String)JspELParserUtil.convertToJspExpression((String)"foo#{bar'}"));
    }

    public void testConvertToJspExpression19() {
        JspELParserUtilTest.assertEquals((String)"19", (String)"${bar == null}", (String)JspELParserUtil.convertToJspExpression((String)"#{bar == null}"));
    }

    public void testConvertToJspExpression20() {
        JspELParserUtilTest.assertEquals((String)"20", (String)"'${hoge}'", (String)JspELParserUtil.convertToJspExpression((String)"'#{hoge}'"));
    }

    public void testConvertToJspExpression21() {
        JspELParserUtilTest.assertEquals((String)"21", (String)"'${'hoge'}'", (String)JspELParserUtil.convertToJspExpression((String)"'#{'hoge'}'"));
    }
}

