/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.application;

import java.util.Iterator;
import javax.faces.application.FacesMessage;
import junit.framework.TestCase;
import org.seasar.framework.util.ClassUtil;
import org.seasar.teeda.core.render.Base64EncodeConverter;
import org.seasar.teeda.core.unit.ExceptionAssert;

public class FacesMessageTest
extends TestCase {
    public void testConstants() throws Exception {
        FacesMessageTest.assertEquals((String)"javax.faces.Messages", (String)"javax.faces.Messages");
    }

    public void testConstant_Values() throws Exception {
        int prevOrdinal = Integer.MIN_VALUE;
        Iterator it = FacesMessage.VALUES.iterator();
        while (it.hasNext()) {
            FacesMessage.Severity severity = (FacesMessage.Severity)it.next();
            severity.getOrdinal();
            int ordinal = severity.getOrdinal();
            FacesMessageTest.assertEquals((boolean)true, (prevOrdinal < ordinal ? 1 : 0) != 0);
            prevOrdinal = ordinal;
        }
    }

    public void testConstructor1() throws Exception {
        FacesMessage facesMessage = new FacesMessage();
        FacesMessageTest.assertEquals((Object)FacesMessage.SEVERITY_INFO, (Object)facesMessage.getSeverity());
    }

    public void testConstructor2() throws Exception {
        FacesMessage facesMessage = new FacesMessage("ss");
        FacesMessageTest.assertEquals((Object)FacesMessage.SEVERITY_INFO, (Object)facesMessage.getSeverity());
        FacesMessageTest.assertEquals((String)"ss", (String)facesMessage.getSummary());
        FacesMessageTest.assertEquals((String)"ss", (String)facesMessage.getDetail());
    }

    public void testConstructor3() throws Exception {
        FacesMessage facesMessage = new FacesMessage("ss", "ddd");
        FacesMessageTest.assertEquals((Object)FacesMessage.SEVERITY_INFO, (Object)facesMessage.getSeverity());
        FacesMessageTest.assertEquals((String)"ddd", (String)facesMessage.getDetail());
        FacesMessageTest.assertEquals((String)"ss", (String)facesMessage.getSummary());
    }

    public void testConstructor4() throws Exception {
        FacesMessage facesMessage = new FacesMessage(FacesMessage.SEVERITY_WARN, "ss", "ddd");
        FacesMessageTest.assertEquals((Object)FacesMessage.SEVERITY_WARN, (Object)facesMessage.getSeverity());
        FacesMessageTest.assertEquals((String)"ddd", (String)facesMessage.getDetail());
        FacesMessageTest.assertEquals((String)"ss", (String)facesMessage.getSummary());
    }

    public void testConstructor4_UnsupportedSeverity() throws Exception {
        try {
            new FacesMessage(new FacesMessage.Severity("AAA", 7650), "ss", "ddd");
            FacesMessageTest.fail();
        }
        catch (IllegalArgumentException iae) {
            ExceptionAssert.assertMessageExist(iae);
        }
    }

    public void testSetGetDetail() throws Exception {
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setDetail("d");
        FacesMessageTest.assertEquals((String)"d", (String)facesMessage.getDetail());
    }

    public void testSetGetDetail_InsteadSummary() throws Exception {
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setSummary("s");
        FacesMessageTest.assertEquals((String)"s", (String)facesMessage.getDetail());
    }

    public void testSetGetSummary() throws Exception {
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setSummary("s");
        FacesMessageTest.assertEquals((String)"s", (String)facesMessage.getSummary());
    }

    public void testSetGetSeverity() throws Exception {
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setSeverity(FacesMessage.SEVERITY_FATAL);
        FacesMessageTest.assertEquals((Object)FacesMessage.SEVERITY_FATAL, (Object)facesMessage.getSeverity());
    }

    public void testSetGetSeverity_UnsupportedSeverity() throws Exception {
        FacesMessage facesMessage = new FacesMessage();
        try {
            facesMessage.setSeverity(new FacesMessage.Severity("BBB", -200));
            FacesMessageTest.fail();
        }
        catch (IllegalArgumentException iae) {
            ExceptionAssert.assertMessageExist(iae);
        }
    }

    public void testSerialize() throws Exception {
        FacesMessage fm = new FacesMessage(FacesMessage.SEVERITY_ERROR, "a", "b");
        Base64EncodeConverter converter = new Base64EncodeConverter();
        String str = converter.getAsEncodeString((Object)fm);
        Object obj = converter.getAsDecodeObject(str);
        FacesMessageTest.assertNotNull((Object)obj);
        FacesMessageTest.assertTrue((boolean)(obj instanceof FacesMessage));
        FacesMessage f = (FacesMessage)obj;
        FacesMessageTest.assertEquals((int)FacesMessage.SEVERITY_ERROR.getOrdinal(), (int)f.getSeverity().getOrdinal());
    }

    public void testInstanciation() throws Exception {
        FacesMessage fm = (FacesMessage)ClassUtil.newInstance((String)FacesMessage.class.getName());
        fm.setSeverity(FacesMessage.SEVERITY_ERROR);
    }
}

