/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import java.io.IOException;
import java.util.Map;
import javax.faces.application.StateManager;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.seasar.teeda.core.render.AbstractResponseStateManager;
import org.seasar.teeda.core.render.html.StructureAndState;
import org.seasar.teeda.core.util.StateManagerUtil;

public class HtmlResponseStateManager
extends AbstractResponseStateManager {
    public void writeState(FacesContext context, StateManager.SerializedView serializedView) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        this.writeSerializedView(context, serializedView, writer);
        this.writeViewId(writer, context.getViewRoot().getViewId());
    }

    private void writeSerializedView(FacesContext context, StateManager.SerializedView serializedView, ResponseWriter writer) throws IOException {
        writer.startElement("input", null);
        writer.writeAttribute("type", "hidden", null);
        writer.writeAttribute("name", "javax.faces.ViewState", null);
        writer.writeAttribute("id", "javax.faces.ViewState", null);
        Object value = this.isSavingStateInClient(context) ? this.getEncodeConverter().getAsEncodeString(new StructureAndState(serializedView)) : serializedView.getStructure();
        writer.writeAttribute("value", value, null);
        writer.endElement("input");
    }

    boolean isSavingStateInClient(FacesContext context) {
        return StateManagerUtil.isSavingStateInClient(context);
    }

    public Object getComponentStateToRestore(FacesContext context) {
        Map requestMap = context.getExternalContext().getRequestMap();
        Object state = requestMap.get(FACES_VIEW_STATE);
        requestMap.remove(FACES_VIEW_STATE);
        return state;
    }

    public Object getTreeStructureToRestore(FacesContext context, String viewId) {
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        String viewIdParam = (String)paramMap.get(VIEW_ID);
        String viewState = (String)paramMap.get("javax.faces.ViewState");
        if (viewState == null || viewIdParam == null) {
            return null;
        }
        if (this.isSavingStateInClient(context)) {
            if (!viewIdParam.equals(viewId)) {
                return null;
            }
            StructureAndState structureAndState = (StructureAndState)this.getEncodeConverter().getAsDecodeObject(viewState);
            context.getExternalContext().getRequestMap().put(AbstractResponseStateManager.FACES_VIEW_STATE, structureAndState.getState());
            return structureAndState.getStructure();
        }
        return viewState;
    }

    protected void writeViewId(ResponseWriter writer, String viewId) throws IOException {
        writer.startElement("input", null);
        writer.writeAttribute("type", "hidden", null);
        writer.writeAttribute("name", VIEW_ID, null);
        writer.writeAttribute("id", VIEW_ID, null);
        writer.writeAttribute("value", viewId, null);
        writer.endElement("input");
    }
}

