/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.internal;

import java.util.ArrayList;
import java.util.Locale;
import javax.faces.internal.JavaMessageResourceBundle;
import javax.faces.internal.MessageResourceBundleChain;
import org.seasar.framework.container.hotdeploy.HotdeployUtil;
import org.seasar.framework.message.MessageResourceBundle;
import org.seasar.framework.message.MessageResourceBundleFactory;
import org.seasar.teeda.core.util.DIContainerUtil;

public class MessageResourceBundleChainFactory {
    private static MessageResourceBundle[] userBundles = null;

    private MessageResourceBundleChainFactory() {
    }

    public static MessageResourceBundle createChain(String bundleName, Locale locale) {
        if (!DIContainerUtil.hasContainer() || !DIContainerUtil.hasComponent(MessageResourceBundle.class)) {
            return MessageResourceBundleChainFactory.createSimpleMessageResourceBundle(bundleName, locale);
        }
        MessageResourceBundleChain chain = new MessageResourceBundleChain();
        if (userBundles == null) {
            ArrayList<MessageResourceBundle> list = new ArrayList<MessageResourceBundle>();
            Object[] components = DIContainerUtil.findAllComponents(MessageResourceBundle.class);
            for (int i = 0; i < components.length; ++i) {
                MessageResourceBundle bundle = (MessageResourceBundle)components[i];
                chain.addMessageResourceBundle(bundle);
                list.add(bundle);
            }
            userBundles = list.toArray(new MessageResourceBundle[components.length]);
        } else {
            for (int i = 0; i < userBundles.length; ++i) {
                chain.addMessageResourceBundle(userBundles[i]);
            }
        }
        MessageResourceBundle defaultBundle = MessageResourceBundleChainFactory.createSimpleMessageResourceBundle(bundleName, locale);
        if (defaultBundle != null) {
            chain.addMessageResourceBundle(defaultBundle);
        }
        return chain;
    }

    public static void clearUserBundles() {
        userBundles = null;
    }

    private static MessageResourceBundle createSimpleMessageResourceBundle(String bundleName, Locale locale) {
        if (HotdeployUtil.isHotdeploy()) {
            return MessageResourceBundleFactory.getNullableBundle((String)bundleName, (Locale)locale);
        }
        return new JavaMessageResourceBundle(bundleName, locale);
    }
}

