/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.util.Map;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBaseTeedaTest;
import javax.faces.component.UIData;
import javax.faces.component.html.HtmlInputText;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import junitx.framework.ArrayAssert;
import junitx.framework.ObjectAssert;
import org.seasar.teeda.core.el.ELParser;
import org.seasar.teeda.core.el.ExpressionProcessor;
import org.seasar.teeda.core.el.impl.ValueBindingImpl;
import org.seasar.teeda.core.el.impl.commons.CommonsELParser;
import org.seasar.teeda.core.el.impl.commons.CommonsExpressionProcessorImpl;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockUIComponentBase;
import org.seasar.teeda.core.mock.MockUIComponentBaseWithNamingContainer;
import org.seasar.teeda.core.mock.MockVariableResolver;

public class UIDataTeedaTest
extends UIComponentBaseTeedaTest {
    public void testGetCliendId() throws Exception {
        UIData component = this.createUIData();
        component.setId("foo");
        UIDataTeedaTest.assertEquals((String)"foo:0", (String)component.getClientId((FacesContext)this.getFacesContext()));
    }

    public void testGetClientId_WithParentNamingContainer() {
        UIData component = this.createUIData();
        component.setId("a");
        MockUIComponentBaseWithNamingContainer parent = new MockUIComponentBaseWithNamingContainer();
        parent.setClientId("b");
        parent.getChildren().add(component);
        String clientId = component.getClientId((FacesContext)this.getFacesContext());
        UIDataTeedaTest.assertNotNull((Object)clientId);
        UIDataTeedaTest.assertEquals((String)"b:a:0", (String)clientId);
    }

    public void testGetClientId_WithParentNotNamingContainer() {
        UIData component = this.createUIData();
        component.setId("a");
        MockUIComponentBase parent = new MockUIComponentBase();
        ObjectAssert.assertNotInstanceOf((Class)NamingContainer.class, (Object)((Object)parent));
        parent.setClientId("b");
        parent.getChildren().add(component);
        String clientId = component.getClientId((FacesContext)this.getFacesContext());
        UIDataTeedaTest.assertNotNull((Object)clientId);
        UIDataTeedaTest.assertEquals((String)"a:0", (String)clientId);
    }

    public void testSetGetRowIndexAndSaveRestoreState() throws Exception {
        UIData data = this.createUIData();
        data.setVar("foo");
        data.setValue((Object)new String[]{"a", "b", "c", "d"});
        UIColumn col = new UIColumn();
        MockFacesContext facesContext = this.getFacesContext();
        CommonsELParser parser = new CommonsELParser();
        parser.setExpressionProcessor((ExpressionProcessor)new CommonsExpressionProcessorImpl());
        ValueBindingImpl vb = new ValueBindingImpl(facesContext.getApplication(), "#{foo}", (ELParser)parser);
        HtmlInputText editableValueHolder = new HtmlInputText();
        editableValueHolder.setValueBinding("value", (ValueBinding)vb);
        UIDataTeedaTest.assertEquals(null, (Object)editableValueHolder.getValue());
        col.getChildren().add(editableValueHolder);
        data.getChildren().add(col);
        data.setRowIndex(123);
        UIDataTeedaTest.assertEquals((int)123, (int)data.getRowIndex());
        UIDataTeedaTest.assertEquals((boolean)false, (boolean)data.isRowAvailable());
        data.setRowIndex(1);
        UIDataTeedaTest.assertEquals((int)1, (int)data.getRowIndex());
        UIDataTeedaTest.assertEquals((boolean)true, (boolean)data.isRowAvailable());
        Map req = facesContext.getExternalContext().getRequestMap();
        UIDataTeedaTest.assertEquals((Object)"b", req.get("foo"));
        MockVariableResolver vr = this.getVariableResolver();
        UIDataTeedaTest.assertEquals((Object)"b", (Object)vr.resolveVariable((FacesContext)facesContext, "foo"));
        UIDataTeedaTest.assertEquals((Object)"b", (Object)editableValueHolder.getValue());
        editableValueHolder.setValue((Object)"b2");
        UIDataTeedaTest.assertEquals((Object)"b2", (Object)editableValueHolder.getValue());
        UIDataTeedaTest.assertEquals((Object)"b", req.get("foo"));
        UIDataTeedaTest.assertEquals((Object)"b", (Object)this.getVariableResolver().resolveVariable((FacesContext)facesContext, "foo"));
        data.setRowIndex(2);
        UIDataTeedaTest.assertEquals((int)2, (int)data.getRowIndex());
        UIDataTeedaTest.assertEquals((boolean)true, (boolean)data.isRowAvailable());
        UIDataTeedaTest.assertEquals((Object)"c", req.get("foo"));
        UIDataTeedaTest.assertEquals((Object)"c", (Object)vr.resolveVariable((FacesContext)facesContext, "foo"));
        UIDataTeedaTest.assertEquals((Object)"c", (Object)editableValueHolder.getValue());
        data.setRowIndex(1);
        UIDataTeedaTest.assertEquals((boolean)true, (boolean)data.isRowAvailable());
        UIDataTeedaTest.assertEquals((String)"restore state of EditableValueHolder's", (Object)"b2", (Object)editableValueHolder.getValue());
        UIDataTeedaTest.assertEquals((Object)"b", req.get("foo"));
        UIDataTeedaTest.assertEquals((Object)"b", (Object)vr.resolveVariable((FacesContext)facesContext, "foo"));
        data.setRowIndex(-1);
        UIDataTeedaTest.assertEquals((boolean)false, (boolean)data.isRowAvailable());
        UIDataTeedaTest.assertEquals(null, req.get("foo"));
        UIDataTeedaTest.assertEquals(null, (Object)vr.resolveVariable((FacesContext)facesContext, "foo"));
        UIDataTeedaTest.assertEquals(null, (Object)editableValueHolder.getValue());
    }

    public void testEncodeBegin_resetSavedState() throws Exception {
        UIData data = this.createUIData();
        data.setVar("foo");
        data.setValue((Object)new String[]{"a", "original"});
        UIColumn col = new UIColumn();
        MockFacesContext facesContext = this.getFacesContext();
        CommonsELParser parser = new CommonsELParser();
        parser.setExpressionProcessor((ExpressionProcessor)new CommonsExpressionProcessorImpl());
        ValueBindingImpl vb = new ValueBindingImpl(facesContext.getApplication(), "#{foo}", (ELParser)parser);
        HtmlInputText editableValueHolder = new HtmlInputText();
        editableValueHolder.setValueBinding("value", (ValueBinding)vb);
        UIDataTeedaTest.assertEquals(null, (Object)editableValueHolder.getValue());
        col.getChildren().add(editableValueHolder);
        data.getChildren().add(col);
        data.setRowIndex(1);
        EditableValueHolder holder = (EditableValueHolder)((UIColumn)data.getChildren().get(0)).getChildren().get(0);
        UIDataTeedaTest.assertEquals((Object)"original", (Object)holder.getValue());
        holder.setValue((Object)"changed");
        data.setRowIndex(0);
        data.setRowIndex(1);
        UIDataTeedaTest.assertEquals((Object)"changed", (Object)holder.getValue());
        data.setRowIndex(0);
        data.encodeBegin((FacesContext)facesContext);
        UIDataTeedaTest.assertEquals((Object)"a", (Object)holder.getValue());
        data.setRowIndex(1);
        UIDataTeedaTest.assertEquals((Object)"original", (Object)holder.getValue());
    }

    public void testSaveAndRestoreState() throws Exception {
        super.testSaveAndRestoreState();
        UIData data1 = this.createUIData();
        data1.setFirst(10);
        data1.setValue((Object)new String[]{"A", "B", "C"});
        MockFacesContext context = this.getFacesContext();
        Object state = data1.saveState((FacesContext)context);
        UIData data2 = this.createUIData();
        data2.restoreState((FacesContext)context, this.serializeAndDeserialize(state));
        UIDataTeedaTest.assertEquals((int)data1.getFirst(), (int)data2.getFirst());
        UIDataTeedaTest.assertEquals((int)data1.getRowCount(), (int)data2.getRowCount());
        UIDataTeedaTest.assertEquals((Object)data1.getRowData(), (Object)data2.getRowData());
        UIDataTeedaTest.assertEquals((int)data1.getRowIndex(), (int)data2.getRowIndex());
        UIDataTeedaTest.assertEquals((int)data1.getRows(), (int)data2.getRows());
        ArrayAssert.assertEquals((Object[])((String[])data1.getValue()), (Object[])((String[])data2.getValue()));
        UIDataTeedaTest.assertEquals((String)data1.getVar(), (String)data2.getVar());
        UIDataTeedaTest.assertEquals((boolean)data1.isRowAvailable(), (boolean)data2.isRowAvailable());
    }

    private UIData createUIData() {
        return (UIData)this.createUIComponent();
    }

    protected UIComponent createUIComponent() {
        return new UIData();
    }
}

