/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.taglib.core;

import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.ValueChangeListener;
import javax.faces.internal.ValueBindingUtil;
import javax.faces.webapp.UIComponentTag;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.seasar.framework.util.ClassUtil;
import org.seasar.teeda.core.exception.NoEditableValueHolderRuntimeException;

public class ValueChangeListenerTag
extends TagSupport {
    private static final long serialVersionUID = 1L;
    private String type = null;

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public int doStartTag() throws JspException {
        String className;
        String type = this.getType();
        if (type == null) {
            throw new JspException("type attribute not set");
        }
        UIComponentTag tag = UIComponentTag.getParentUIComponentTag(this.pageContext);
        if (tag == null) {
            throw new JspException("Not nested in a UIComponentTag");
        }
        if (!tag.getCreated()) {
            return 0;
        }
        UIComponent component = tag.getComponentInstance();
        if (component == null) {
            throw new JspException("No component associated with UIComponentTag");
        }
        if (component instanceof EditableValueHolder) {
            className = null;
            if (UIComponentTag.isValueReference(type)) {
                FacesContext context = FacesContext.getCurrentInstance();
                ValueBinding vb = ValueBindingUtil.createValueBinding(context, type);
                className = (String)vb.getValue(context);
            } else {
                className = type;
            }
        } else {
            throw new NoEditableValueHolderRuntimeException(component.getClass());
        }
        ValueChangeListener listener = (ValueChangeListener)ClassUtil.newInstance((String)className);
        ((EditableValueHolder)((Object)component)).addValueChangeListener(listener);
        return 0;
    }

    public void release() {
        super.release();
        this.type = null;
    }
}

