/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.util;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PatternUtil {
    private static Map patternCache = new HashMap();

    private PatternUtil() {
    }

    public static Pattern getPattern(String regex) {
        Pattern pattern = (Pattern)patternCache.get(regex);
        if (pattern == null) {
            pattern = Pattern.compile(regex);
            patternCache.put(regex, pattern);
        }
        return pattern;
    }

    public static boolean matches(String regex, CharSequence value) {
        if (regex == null) {
            throw new IllegalArgumentException("regex");
        }
        Pattern pattern = PatternUtil.getPattern(regex);
        Matcher matcher = pattern.matcher(value);
        return matcher.matches();
    }

    public static void clearPatternCache() {
        patternCache.clear();
    }
}

