/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.service;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.seasar.extension.jdbc.AutoSelect;
import org.seasar.extension.jdbc.JdbcManager;
import org.seasar.extension.jdbc.SqlFileSelect;
import org.seasar.extension.jdbc.SqlFileUpdate;
import org.seasar.framework.beans.util.BeanMap;
import org.seasar.framework.util.StringUtil;
import org.seasar.framework.util.tiger.GenericUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class S2AbstractService<T> {
    @Resource
    protected JdbcManager jdbcManager;
    protected Class<T> entityClass;
    protected String sqlFilePathPrefix;

    public S2AbstractService() {
        Map<TypeVariable<?>, Type> map = GenericUtil.getTypeVariableMap(this.getClass());
        for (Class<?> c = this.getClass(); c != Object.class; c = c.getSuperclass()) {
            if (c.getSuperclass() != S2AbstractService.class) continue;
            Type type = c.getGenericSuperclass();
            Type[] arrays = GenericUtil.getGenericParameter(type);
            this.setEntityClass(GenericUtil.getActualClass(arrays[0], map));
            break;
        }
    }

    public S2AbstractService(Class<T> entityClass) {
        this.setEntityClass(entityClass);
    }

    protected AutoSelect<T> select() {
        return this.jdbcManager.from(this.entityClass);
    }

    public List<T> findAll() {
        return this.select().getResultList();
    }

    public List<T> findByCondition(BeanMap conditions) {
        return this.select().where(conditions).getResultList();
    }

    public long getCount() {
        return this.select().getCount();
    }

    public int insert(T entity) {
        return this.jdbcManager.insert(entity).execute();
    }

    public int update(T entity) {
        return this.jdbcManager.update(entity).execute();
    }

    public int delete(T entity) {
        return this.jdbcManager.delete(entity).execute();
    }

    protected <T2> SqlFileSelect<T2> selectBySqlFile(Class<T2> baseClass, String path) {
        return this.jdbcManager.selectBySqlFile(baseClass, this.sqlFilePathPrefix + path);
    }

    protected <T2> SqlFileSelect<T2> selectBySqlFile(Class<T2> baseClass, String path, Object parameter) {
        return this.jdbcManager.selectBySqlFile(baseClass, this.sqlFilePathPrefix + path, parameter);
    }

    protected SqlFileUpdate updateBySqlFile(String path) {
        return this.jdbcManager.updateBySqlFile(this.sqlFilePathPrefix + path);
    }

    protected SqlFileUpdate updateBySqlFile(String path, Object parameter) {
        return this.jdbcManager.updateBySqlFile(this.sqlFilePathPrefix + path, parameter);
    }

    protected void setEntityClass(Class<T> entityClass) {
        this.entityClass = entityClass;
        this.sqlFilePathPrefix = "META-INF/sql/" + StringUtil.replace((String)entityClass.getName(), (String)".", (String)"/") + "/";
    }
}

