/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.config.faces;

import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.seasar.framework.container.factory.ClassPathResourceResolver;
import org.seasar.framework.container.factory.ResourceResolver;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.InputStreamUtil;
import org.seasar.framework.util.SAXParserFactoryUtil;
import org.seasar.framework.xml.SaxHandler;
import org.seasar.framework.xml.SaxHandlerParser;
import org.seasar.framework.xml.TagHandlerRule;
import org.seasar.teeda.core.config.faces.FacesConfigurator;
import org.seasar.teeda.core.config.faces.element.FacesConfig;
import org.seasar.teeda.core.config.faces.rule.FacesConfigTagHandlerRule;

public abstract class AbstractFacesConfigurator
implements FacesConfigurator {
    private static final Logger logger_ = Logger.getLogger((Class)AbstractFacesConfigurator.class);
    private static final String FACES_CONFIG_1_1 = "-//Sun Microsystems, Inc.//DTD JavaServer Faces Config 1.1//EN";
    private static final String FACES_CONFIG_1_0 = "-//Sun Microsystems, Inc.//DTD JavaServer Faces Config 1.0//EN";
    private static final String FACES_1_1_DTD_PATH = "org/seasar/teeda/core/resource/web-facesconfig_1_1.dtd";
    private static final String FACES_1_0_DTD_PATH = "org/seasar/teeda/core/resource/web-facesconfig_1_0.dtd";
    protected ResourceResolver resourceResolver_ = new ClassPathResourceResolver();
    protected TagHandlerRule rule_ = new FacesConfigTagHandlerRule();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FacesConfig configure() {
        String path = this.getPath();
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("target file path = " + path));
        }
        SaxHandlerParser parser = this.createSaxHandlerParser();
        InputStream is = this.resourceResolver_.getInputStream(path);
        if (is == null) {
            return null;
        }
        try {
            FacesConfig facesConfig = (FacesConfig)parser.parse(is, path);
            return facesConfig;
        }
        finally {
            InputStreamUtil.close((InputStream)is);
        }
    }

    protected final SaxHandlerParser createSaxHandlerParser() {
        SAXParserFactory factory = SAXParserFactoryUtil.newInstance();
        factory.setValidating(true);
        SAXParser saxParser = SAXParserFactoryUtil.newSAXParser((SAXParserFactory)factory);
        SaxHandler handler = new SaxHandler(this.rule_);
        handler.registerDtdPath(FACES_CONFIG_1_1, FACES_1_1_DTD_PATH);
        handler.registerDtdPath(FACES_CONFIG_1_0, FACES_1_0_DTD_PATH);
        SaxHandlerParser parser = new SaxHandlerParser(handler, saxParser);
        return parser;
    }

    public void setResourceResolver(ResourceResolver resourceResolver) {
        this.resourceResolver_ = resourceResolver;
    }

    public ResourceResolver getResourceResolver() {
        return this.resourceResolver_;
    }

    public void setTagHandlerRule(TagHandlerRule rule) {
        this.rule_ = rule;
    }

    public TagHandlerRule getTagHandlerRule() {
        return this.rule_;
    }

    protected abstract String getPath();
}

