/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.taglib.core;

import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.internal.ValueBindingUtil;
import javax.faces.validator.LengthValidator;
import javax.faces.validator.Validator;
import javax.servlet.jsp.JspException;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.teeda.core.taglib.core.MaxMinValidatorTag;
import org.seasar.teeda.core.util.BindingUtil;
import org.seasar.teeda.core.util.ConverterUtil;

public class ValidateLengthTag
extends MaxMinValidatorTag {
    private static final long serialVersionUID = 1L;
    private static final String VALIDATOR_ID = "javax.faces.Length";
    protected int minimum = 0;
    protected int maximum = 0;

    protected Validator createValidator() throws JspException {
        super.setValidatorId(VALIDATOR_ID);
        LengthValidator validator = (LengthValidator)super.createValidator();
        AssertionUtil.assertNotNull((String)"LengthValidator", (Object)validator);
        this.evaluateExpressions();
        if (this.isMinimumSet()) {
            validator.setMinimum(this.minimum);
        }
        if (this.isMaximumSet()) {
            validator.setMaximum(this.maximum);
        }
        return validator;
    }

    private void evaluateExpressions() throws JspException {
        String max;
        FacesContext context = FacesContext.getCurrentInstance();
        String min = this.getMinimum();
        if (min != null) {
            if (BindingUtil.isValueReference(min)) {
                ValueBinding vb = ValueBindingUtil.createValueBinding(context, min);
                this.minimum = ConverterUtil.convertToInt(vb.getValue(context));
            } else {
                this.minimum = ConverterUtil.convertToInt(min);
            }
        }
        if ((max = this.getMaximum()) != null) {
            if (BindingUtil.isValueReference(max)) {
                ValueBinding vb = context.getApplication().createValueBinding(max);
                this.maximum = ConverterUtil.convertToInt(vb.getValue(context));
            } else {
                this.maximum = ConverterUtil.convertToInt(max);
            }
        }
    }
}

