/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.autoregister;

import org.aopalliance.intercept.MethodInterceptor;
import org.seasar.framework.aop.Pointcut;
import org.seasar.framework.container.AspectDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.AspectDefFactory;

public class InterfaceAspectAutoRegister {
    public static final String INIT_METHOD = "registerAll";
    private S2Container container;
    private MethodInterceptor interceptor;
    private Class targetInterface;
    private Pointcut pointcut;

    public void setContainer(S2Container container) {
        this.container = container;
    }

    public void setInterceptor(MethodInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public void setTargetInterface(Class targetInterface) {
        if (!targetInterface.isInterface()) {
            throw new IllegalArgumentException(targetInterface.getName());
        }
        this.targetInterface = targetInterface;
        this.pointcut = AspectDefFactory.createPointcut(targetInterface);
    }

    public void registerAll() {
        for (int i = 0; i < this.container.getComponentDefSize(); ++i) {
            ComponentDef cd = this.container.getComponentDef(i);
            this.register(cd);
        }
    }

    protected void register(ComponentDef componentDef) {
        Class componentClass = componentDef.getComponentClass();
        if (componentClass == null) {
            return;
        }
        if (!this.targetInterface.isAssignableFrom(componentClass)) {
            return;
        }
        this.registerInterceptor(componentDef);
    }

    protected void registerInterceptor(ComponentDef componentDef) {
        AspectDef aspectDef = AspectDefFactory.createAspectDef(this.interceptor, this.pointcut);
        componentDef.addAspectDef(aspectDef);
    }
}

