/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render;

import java.util.Map;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.teeda.core.render.Decoder;

public abstract class AbstractDecoder
implements Decoder {
    public void decode(FacesContext context, UIComponent component) {
        AssertionUtil.assertNotNull((String)"context is null.", (Object)context);
        AssertionUtil.assertNotNull((String)"component is null.", (Object)component);
        ValueHolderWrapper wrapper = this.createValueHolderWrapper(component);
        Map paramMap = this.getRequestParameterMap(context);
        String clientId = this.getClientId(component, context);
        if (paramMap.containsKey(clientId)) {
            Object value = paramMap.get(clientId);
            wrapper.setValue(value);
        }
    }

    public void decodeMany(FacesContext context, UIComponent component) {
        AssertionUtil.assertNotNull((String)"context is null.", (Object)context);
        AssertionUtil.assertNotNull((String)"component is null.", (Object)component);
        ValueHolderWrapper wrapper = this.createValueHolderWrapper(component);
        Map paramValuesMap = this.getRequestParameterValuesMap(context);
        String clientId = this.getClientId(component, context);
        String[] value = null;
        if (paramValuesMap.containsKey(clientId)) {
            value = (String[])paramValuesMap.get(clientId);
        }
        if (value != null) {
            wrapper.setValue(value);
        } else {
            wrapper.setValue(new String[0]);
        }
    }

    protected abstract ValueHolderWrapper createValueHolderWrapper(UIComponent var1);

    protected Map getRequestParameterMap(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap();
    }

    protected Map getRequestParameterValuesMap(FacesContext context) {
        return context.getExternalContext().getRequestParameterValuesMap();
    }

    protected String getClientId(UIComponent component, FacesContext context) {
        return component.getClientId(context);
    }

    protected static class ValueHolderWrapper {
        private ValueHolder holder;

        public ValueHolderWrapper(ValueHolder holder) {
            this.holder = holder;
        }

        public void setValue(Object value) {
            if (this.holder instanceof EditableValueHolder) {
                ((EditableValueHolder)this.holder).setSubmittedValue(value);
            } else {
                this.holder.setValue(value);
            }
        }

        public Object getValue() {
            if (this.holder instanceof EditableValueHolder) {
                return ((EditableValueHolder)this.holder).getSubmittedValue();
            }
            return this.holder.getValue();
        }
    }
}

