/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.unit;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.ejb.EJB;
import javax.transaction.TransactionManager;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.S2ContainerFactory;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.container.impl.S2ContainerBehavior;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.convention.impl.NamingConventionImpl;
import org.seasar.framework.env.Env;
import org.seasar.framework.exception.NoSuchMethodRuntimeException;
import org.seasar.framework.unit.EasyMockSupport;
import org.seasar.framework.unit.InternalTestContext;
import org.seasar.framework.unit.S2TestIntrospector;
import org.seasar.framework.unit.UnitClassLoader;
import org.seasar.framework.unit.annotation.PublishedTestContext;
import org.seasar.framework.util.DisposableUtil;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.framework.util.tiger.CollectionsUtil;
import org.seasar.framework.util.tiger.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S2TestMethodRunner {
    protected static final String DEFAULT_S2JUNIT4_PATH = "s2junit4.dicon";
    protected static String s2junit4Path = "s2junit4.dicon";
    protected final Object test;
    protected final Class<?> testClass;
    protected final Method method;
    protected final RunNotifier notifier;
    protected final Description description;
    protected final S2TestIntrospector introspector;
    protected ClassLoader originalClassLoader;
    protected UnitClassLoader unitClassLoader;
    protected InternalTestContext testContext;
    private List<Field> boundFields = CollectionsUtil.newArrayList();
    protected EasyMockSupport easyMockSupport = new EasyMockSupport();
    protected boolean testFailed;

    public S2TestMethodRunner(Object test, Method method, RunNotifier notifier, Description description, S2TestIntrospector introspector) {
        this.test = test;
        this.testClass = test.getClass();
        this.method = method;
        this.notifier = notifier;
        this.description = description;
        this.introspector = introspector;
        this.notifier.addListener(new RunListener(){

            public void testFailure(Failure failure) throws Exception {
                S2TestMethodRunner.this.testFailed = true;
            }
        });
    }

    protected void addFailure(Throwable e) {
        Failure failure = new Failure(this.description, e);
        this.notifier.fireTestFailure(failure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Env.setFilePath((String)"env_ut.txt");
            Env.setValueIfAbsent((String)"ut");
            if (this.isIgnored() || !this.isFulfilled()) {
                this.notifier.fireTestIgnored(this.description);
                return;
            }
            this.notifier.fireTestStarted(this.description);
            try {
                long timeout = this.introspector.getTimeout(this.method);
                if (timeout > 0L) {
                    this.runWithTimeout(timeout);
                } else {
                    this.runMethod();
                }
            }
            finally {
                this.notifier.fireTestFinished(this.description);
            }
        }
        finally {
            Env.initialize();
        }
    }

    protected boolean isIgnored() {
        return this.introspector.isIgnored(this.method);
    }

    protected boolean isFulfilled() {
        return this.introspector.isFulfilled(this.testClass, this.method, this.test);
    }

    protected void runWithTimeout(long timeout) {
        ExecutorService service = Executors.newSingleThreadExecutor();
        Callable<Object> callable = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                S2TestMethodRunner.this.runMethod();
                return null;
            }
        };
        Future<Object> result = service.submit(callable);
        service.shutdown();
        try {
            boolean terminated = service.awaitTermination(timeout, TimeUnit.MILLISECONDS);
            if (!terminated) {
                service.shutdownNow();
            }
            result.get(0L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            this.addFailure(new Exception(String.format("test timed out after %d milliseconds", timeout)));
        }
        catch (Exception e) {
            this.addFailure(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void runMethod() {
        block26: {
            this.easyMockSupport.clear();
            try {
                this.setUpTestContext();
                try {
                    this.runBefores();
                    try {
                        this.runEachBefore();
                        this.initContainer();
                        try {
                            this.testContext.registerColumnTypes();
                            try {
                                this.bindFields();
                                try {
                                    boolean recorded = this.runEachRecord();
                                    if (recorded) {
                                        this.easyMockSupport.replay();
                                    }
                                    this.runTest();
                                    if (recorded) {
                                        this.easyMockSupport.verify();
                                        this.easyMockSupport.reset();
                                    }
                                }
                                finally {
                                    this.unbindFields();
                                }
                            }
                            finally {
                                this.testContext.revertColumnTypes();
                            }
                        }
                        finally {
                            this.testContext.destroyContainer();
                        }
                        this.runEachAfter();
                    }
                    catch (FailedBefore e) {
                        this.runEachAfter();
                    }
                    catch (Throwable e) {
                        this.addFailure(e);
                        break block26;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        finally {
                            this.runEachAfter();
                        }
                    }
                }
                catch (FailedBefore e) {
                }
                finally {
                    this.runAfters();
                    this.tearDownTestContext();
                }
            }
            catch (Throwable e) {
                this.addFailure(e);
            }
        }
    }

    protected void setUpTestContext() throws Throwable {
        this.originalClassLoader = this.getOriginalClassLoader();
        this.unitClassLoader = new UnitClassLoader(this.originalClassLoader);
        Thread.currentThread().setContextClassLoader((ClassLoader)this.unitClassLoader);
        if (this.needsWarmDeploy()) {
            S2ContainerFactory.configure((String)"warmdeploy.dicon");
        }
        S2Container container = this.createRootContainer();
        SingletonS2ContainerFactory.setContainer((S2Container)container);
        this.testContext = (InternalTestContext)InternalTestContext.class.cast(container.getComponent(InternalTestContext.class));
        this.testContext.setTestClass(this.testClass);
        this.testContext.setTestMethod(this.method);
        if (!this.testContext.hasComponentDef(NamingConvention.class) && this.introspector.isRegisterNamingConvention(this.testClass, this.method)) {
            NamingConventionImpl namingConvention = new NamingConventionImpl();
            this.testContext.register(namingConvention);
            this.testContext.setNamingConvention((NamingConvention)namingConvention);
        }
        for (Class<?> clazz = this.testClass; clazz != Object.class; clazz = clazz.getSuperclass()) {
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                Class<?> fieldClass = field.getType();
                if (!this.isAutoBindable(field) || !fieldClass.isAssignableFrom(this.testContext.getClass()) || !fieldClass.isAnnotationPresent(PublishedTestContext.class)) continue;
                field.setAccessible(true);
                if (ReflectionUtil.getValue(field, this.test) != null) continue;
                this.bindField(field, this.testContext);
            }
        }
    }

    protected ClassLoader getOriginalClassLoader() {
        S2Container configurationContainer = S2ContainerFactory.getConfigurationContainer();
        if (configurationContainer != null && configurationContainer.hasComponentDef(ClassLoader.class)) {
            return (ClassLoader)ClassLoader.class.cast(configurationContainer.getComponent(ClassLoader.class));
        }
        return Thread.currentThread().getContextClassLoader();
    }

    protected S2Container createRootContainer() {
        String rootDicon = this.introspector.getRootDicon(this.testClass, this.method);
        if (StringUtil.isEmpty((String)rootDicon)) {
            return S2ContainerFactory.create((String)s2junit4Path);
        }
        S2Container container = S2ContainerFactory.create((String)rootDicon);
        S2ContainerFactory.include((S2Container)container, (String)s2junit4Path);
        return container;
    }

    protected void tearDownTestContext() throws Throwable {
        this.testContext = null;
        DisposableUtil.dispose();
        S2ContainerBehavior.setProvider((S2ContainerBehavior.Provider)new S2ContainerBehavior.DefaultProvider());
        Thread.currentThread().setContextClassLoader(this.originalClassLoader);
        this.unitClassLoader = null;
        this.originalClassLoader = null;
    }

    protected void runBefores() throws FailedBefore {
        try {
            List<Method> befores = this.introspector.getBeforeMethods(this.testClass);
            for (Method before : befores) {
                before.invoke(this.test, new Object[0]);
            }
        }
        catch (InvocationTargetException e) {
            this.addFailure(e.getTargetException());
            throw new FailedBefore();
        }
        catch (Throwable e) {
            this.addFailure(e);
            throw new FailedBefore();
        }
    }

    protected void runAfters() {
        List<Method> afters = this.introspector.getAfterMethods(this.testClass);
        for (Method after : afters) {
            try {
                after.invoke(this.test, new Object[0]);
            }
            catch (InvocationTargetException e) {
                this.addFailure(e.getTargetException());
            }
            catch (Throwable e) {
                this.addFailure(e);
            }
        }
    }

    protected void runEachBefore() throws FailedBefore {
        try {
            Method eachBefore = this.introspector.getEachBeforeMethod(this.testClass, this.method);
            if (eachBefore != null) {
                this.invokeMethod(eachBefore);
            }
        }
        catch (Throwable e) {
            this.addFailure(e);
            throw new FailedBefore();
        }
        this.easyMockSupport.bindMockFields(this.test, this.testContext.getContainer());
    }

    protected void runEachAfter() {
        this.easyMockSupport.unbindMockFields(this.test);
        try {
            Method eachAfter = this.introspector.getEachAfterMethod(this.testClass, this.method);
            if (eachAfter != null) {
                this.invokeMethod(eachAfter);
            }
        }
        catch (Throwable e) {
            this.addFailure(e);
        }
    }

    protected void initContainer() {
        this.testContext.include();
        this.introspector.createMock(this.method, this.test, this.testContext);
        this.testContext.initContainer();
    }

    protected void bindFields() throws Throwable {
        for (Class<?> clazz = this.testClass; clazz != Object.class; clazz = clazz.getSuperclass()) {
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                this.bindField(fields[i]);
            }
        }
        List<Method> postBindFieldsMethods = this.introspector.getPostBindFieldsMethods(this.testClass);
        for (Method m : postBindFieldsMethods) {
            m.invoke(this.test, new Object[0]);
        }
    }

    protected void bindField(Field field) {
        if (this.isAutoBindable(field)) {
            field.setAccessible(true);
            if (ReflectionUtil.getValue(field, this.test) != null) {
                return;
            }
            String name = this.resolveComponentName(field);
            Object component = null;
            if (this.testContext.hasComponentDef(name) && (component = this.testContext.getComponent(name)) != null) {
                Class<?> componentClass = component.getClass();
                if (!field.getType().isAssignableFrom(componentClass)) {
                    component = null;
                }
            }
            if (component == null && this.testContext.hasComponentDef(field.getType())) {
                component = this.testContext.getComponent(field.getType());
            }
            if (component != null) {
                this.bindField(field, component);
            }
        }
    }

    protected void bindField(Field field, Object object) {
        ReflectionUtil.setValue(field, this.test, object);
        this.boundFields.add(field);
    }

    protected boolean isAutoBindable(Field field) {
        int modifiers = field.getModifiers();
        return !Modifier.isStatic(modifiers) && !Modifier.isFinal(modifiers) && !field.getType().isPrimitive();
    }

    protected String resolveComponentName(Field filed) {
        EJB ejb;
        if (this.testContext.isEjb3Enabled() && (ejb = filed.getAnnotation(EJB.class)) != null) {
            if (!StringUtil.isEmpty((String)ejb.beanName())) {
                return ejb.beanName();
            }
            if (!StringUtil.isEmpty((String)ejb.name())) {
                return ejb.name();
            }
        }
        return this.normalizeName(filed.getName());
    }

    protected String normalizeName(String name) {
        return StringUtil.replace((String)name, (String)"_", (String)"");
    }

    protected boolean runEachRecord() throws Throwable {
        Method recordMethod = this.introspector.getEachRecordMethod(this.testClass, this.method);
        if (recordMethod != null) {
            this.invokeMethod(recordMethod);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runTest() throws Throwable {
        if (!this.testContext.isJtaEnabled()) {
            this.executeMethod();
            return;
        }
        TransactionManager tm = null;
        if (this.introspector.needsTransaction(this.testClass, this.method)) {
            try {
                tm = this.testContext.getComponent(TransactionManager.class);
                tm.begin();
            }
            catch (Throwable t) {
                System.err.println(t);
            }
        }
        try {
            this.testContext.prepareTestData();
            this.executeMethod();
        }
        finally {
            if (tm != null) {
                if (this.requiresTransactionCommitment()) {
                    tm.commit();
                } else {
                    tm.rollback();
                }
            }
        }
    }

    protected boolean requiresTransactionCommitment() {
        return !this.testFailed && this.introspector.requiresTransactionCommitment(this.testClass, this.method);
    }

    protected void executeMethod() throws Throwable {
        block4: {
            try {
                this.executeMethodBody();
                if (this.expectsException()) {
                    this.addFailure((Throwable)((Object)new AssertionError((Object)("Expected exception: " + this.expectedException().getName()))));
                }
            }
            catch (InvocationTargetException e) {
                Throwable actual = e.getTargetException();
                if (!this.expectsException()) {
                    this.addFailure(actual);
                }
                if (!this.isUnexpected(actual)) break block4;
                String message = "Unexpected exception, expected<" + this.expectedException().getName() + "> but was<" + actual.getClass().getName() + ">";
                this.addFailure(new Exception(message, actual));
            }
        }
    }

    protected void executeMethodBody() throws Throwable {
        this.method.invoke(this.test, new Object[0]);
    }

    protected boolean expectsException() {
        return this.expectedException() != null;
    }

    protected boolean isUnexpected(Throwable exception) {
        return !this.expectedException().isAssignableFrom(exception.getClass());
    }

    protected Class<? extends Throwable> expectedException() {
        return this.introspector.expectedException(this.method);
    }

    protected void invokeMethod(Method method) throws Throwable {
        try {
            ReflectionUtil.invoke(method, this.test, new Object[0]);
        }
        catch (NoSuchMethodRuntimeException noSuchMethodRuntimeException) {
            // empty catch block
        }
    }

    protected void unbindFields() throws Throwable {
        List<Method> preUnbindFieldsMethods = this.introspector.getPreUnbindFieldsMethods(this.testClass);
        for (Method m : preUnbindFieldsMethods) {
            m.invoke(this.test, new Object[0]);
        }
        for (Field field : this.boundFields) {
            try {
                field.set(this.test, null);
            }
            catch (IllegalArgumentException e) {
                System.err.println(e);
            }
            catch (IllegalAccessException e) {
                System.err.println(e);
            }
        }
        this.boundFields = null;
    }

    protected boolean needsWarmDeploy() {
        return this.introspector.needsWarmDeploy(this.testClass, this.method) && !ResourceUtil.isExist((String)"s2container.dicon") && ResourceUtil.isExist((String)"convention.dicon") && ResourceUtil.isExist((String)"creator.dicon") && ResourceUtil.isExist((String)"customizer.dicon");
    }

    private static class FailedBefore
    extends Exception {
        private static final long serialVersionUID = 1L;

        private FailedBefore() {
        }
    }
}

