/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.util;

public final class HTMLEncodeUtil {
    private static HtmlEncodeStrategy encodeStrategy = new DefaultHtmlEncodeStrategy();

    private HTMLEncodeUtil() {
    }

    public static HtmlEncodeStrategy getHtmlEncodeStrategy() {
        return encodeStrategy;
    }

    public static void setHtmlEncodeStrategy(HtmlEncodeStrategy htmlEncodeStrategy) {
        encodeStrategy = htmlEncodeStrategy;
    }

    public static String encodeAll(String s) {
        return HTMLEncodeUtil.encode(s, true, true);
    }

    public static String encode(String s, boolean quote, boolean amp) {
        return encodeStrategy.encode(s, quote, amp);
    }

    public static class JapaneseHtmlEncodeStrategy
    extends AbstractHtmlEncodeStrategy {
        protected void encodeEach(StringBuffer sb, char c, boolean quote, boolean amp) {
            if (c == '\u00a0') {
                sb.append("&nbsp;");
            } else if (c == '<') {
                sb.append("&lt;");
            } else if (c == '>') {
                sb.append("&gt;");
            } else if (amp && c == '&') {
                sb.append("&amp;");
            } else if (c == '\"') {
                sb.append("&quot;");
            } else if (quote && c == '\'') {
                sb.append("&#39;");
            } else if (c == '\u00a5' || c == '\\') {
                sb.append("&yen;");
            } else {
                sb.append(c);
            }
        }
    }

    public static class DefaultHtmlEncodeStrategy
    extends AbstractHtmlEncodeStrategy {
        protected void encodeEach(StringBuffer sb, char c, boolean quote, boolean amp) {
            if (c == '\u00a0') {
                sb.append("&nbsp;");
            } else if (c == '<') {
                sb.append("&lt;");
            } else if (c == '>') {
                sb.append("&gt;");
            } else if (amp && c == '&') {
                sb.append("&amp;");
            } else if (c == '\"') {
                sb.append("&quot;");
            } else if (quote && c == '\'') {
                sb.append("&#39;");
            } else if (c == '\u00a5') {
                sb.append("&yen;");
            } else {
                sb.append(c);
            }
        }
    }

    public static abstract class AbstractHtmlEncodeStrategy
    implements HtmlEncodeStrategy {
        public String encode(String s, boolean quote, boolean amp) {
            char[] chars = s.toCharArray();
            StringBuffer sb = new StringBuffer(s.length() + 64);
            for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                this.encodeEach(sb, c, quote, amp);
            }
            return new String(sb);
        }

        protected abstract void encodeEach(StringBuffer var1, char var2, boolean var3, boolean var4);
    }

    public static interface HtmlEncodeStrategy {
        public String encode(String var1, boolean var2, boolean var3);
    }
}

