/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.application.navigation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.seasar.teeda.core.application.navigation.NavigationContext;

public class NavigationResource {
    private static final String NAVIGATON_CONTEXTS = NavigationResource.class.getName() + "_NAVIGATION_CONTEXTS";
    private static final String WILDCARD_NAVIGATION_CONTEXTS = NavigationResource.class.getName() + "_WILDCARD_NAVIGATION_CONTEXTS";
    private static final String DEFAULT_NAVIGATION_CONTEXTS = NavigationResource.class.getName() + "_DEFAULT_NAVIGATION_CONTEXTS";
    private static Map cache = new HashMap();

    private NavigationResource() {
    }

    public static void addNavigationContext(NavigationContext navigationContext) {
        if (navigationContext == null) {
            throw new IllegalArgumentException("navigationContext");
        }
        String fromViewId = navigationContext.getFromViewId();
        if (navigationContext.isWildCardMatch()) {
            if ("*".equals(fromViewId)) {
                NavigationResource.storeNavigationContext(fromViewId, navigationContext, DEFAULT_NAVIGATION_CONTEXTS);
            } else {
                NavigationResource.storeNavigationContext(fromViewId, navigationContext, WILDCARD_NAVIGATION_CONTEXTS);
            }
        } else {
            NavigationResource.storeNavigationContext(fromViewId, navigationContext, NAVIGATON_CONTEXTS);
        }
    }

    public static void removeNavigationContext(String fromViewId) {
        if (fromViewId == null) {
            throw new IllegalArgumentException(fromViewId);
        }
        Map navContextsMap = (Map)cache.get(NAVIGATON_CONTEXTS);
        if (navContextsMap == null) {
            return;
        }
        navContextsMap.remove(fromViewId);
    }

    public static Map getNavigationContexts() {
        return (Map)cache.get(NAVIGATON_CONTEXTS);
    }

    public static Map getWildCardMatchNavigationContexts() {
        return (Map)cache.get(WILDCARD_NAVIGATION_CONTEXTS);
    }

    public static Map getDefaultMatchNavigationContexts() {
        return (Map)cache.get(DEFAULT_NAVIGATION_CONTEXTS);
    }

    public static void removeAll() {
        cache.clear();
    }

    protected static void storeNavigationContext(String fromViewId, NavigationContext navContext, String applicationKey) {
        ArrayList<NavigationContext> navContextList;
        Map navContextsMap = (Map)cache.get(applicationKey);
        if (navContextsMap == null) {
            navContextsMap = Collections.synchronizedMap(new HashMap());
            cache.put(applicationKey, navContextsMap);
        }
        if ((navContextList = (ArrayList<NavigationContext>)navContextsMap.get(fromViewId)) == null) {
            navContextList = new ArrayList<NavigationContext>();
        }
        navContextList.add(navContext);
        navContextsMap.put(fromViewId, navContextList);
    }
}

