/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.component;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.internal.scope.PageScope;
import org.seasar.framework.container.hotdeploy.HotdeployUtil;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.teeda.extension.util.SessionSaveUtil;

public class TSessionSave
extends UIInput {
    public static final String COMPONENT_TYPE = "org.seasar.teeda.extension.SessionSave";
    public static final String COMPONENT_FAMILY = "org.seasar.teeda.extension.SessionSave";
    public static final String DEFAULT_RENDERER_TYPE = null;
    private static final String SESSION_SAVE = TSessionSave.class.getName();

    public TSessionSave() {
        this.setRendererType(DEFAULT_RENDERER_TYPE);
    }

    public String getFamily() {
        return "org.seasar.teeda.extension.SessionSave";
    }

    public void decode(FacesContext context) {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        Map saveValues = this.getSaveValues(context);
        if (saveValues == null) {
            return;
        }
        ValueBinding valueBinding = this.getValueBinding("value");
        if (valueBinding == null) {
            return;
        }
        String targetId = this.getTargetId();
        Object value = HotdeployUtil.rebuildValue(saveValues.get(targetId));
        this.setValue(value);
        valueBinding.setValue(context, value);
    }

    protected Map getSaveValues(FacesContext context) {
        Map viewContext = PageScope.getOrCreateContext((FacesContext)context);
        return (Map)viewContext.get(SESSION_SAVE);
    }

    protected Map getOrCreateSaveValues(FacesContext context) {
        HashMap saveValues = this.getSaveValues(context);
        if (saveValues == null) {
            Map viewContext = PageScope.getOrCreateContext((FacesContext)context);
            saveValues = new HashMap();
            viewContext.put(SESSION_SAVE, saveValues);
        }
        return saveValues;
    }

    protected String getTargetId() {
        return SessionSaveUtil.convertTargetId(this.getId());
    }

    public void encodeEnd(FacesContext context) throws IOException {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        Object value = this.getValue();
        if (value == null) {
            return;
        }
        Map saveValues = this.getOrCreateSaveValues(context);
        saveValues.put(this.getTargetId(), value);
    }
}

