/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.html.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.seasar.teeda.core.util.EmptyElementUtil;
import org.xml.sax.Attributes;

public class HtmlNodeUtil {
    protected HtmlNodeUtil() {
    }

    public static Map convertMap(Attributes attributes) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String qname = attributes.getQName(i);
            String localName = attributes.getLocalName(i);
            String uri = attributes.getURI(i);
            String value = attributes.getValue(i);
            if ("http://www.seasar.org/teeda/extension".equals(uri)) {
                map.put(localName, value);
                continue;
            }
            if (map.containsKey(qname)) continue;
            map.put(qname, value);
        }
        return map;
    }

    public static String getCompleteTagString(String tagName, Map properties) {
        if (EmptyElementUtil.isEmptyElement((String)tagName)) {
            return HtmlNodeUtil.getStartTagString0(tagName, properties) + " />";
        }
        return HtmlNodeUtil.getStartTagString0(tagName, properties) + ">" + HtmlNodeUtil.getEndTagString0(tagName);
    }

    public static String getStartTagString(String tagName, Map properties) {
        if (EmptyElementUtil.isEmptyElement((String)tagName)) {
            return HtmlNodeUtil.getStartTagString0(tagName, properties) + " />";
        }
        return HtmlNodeUtil.getStartTagString0(tagName, properties) + ">";
    }

    public static String getEndTagString(String tagName) {
        if (EmptyElementUtil.isEmptyElement((String)tagName)) {
            return "";
        }
        return HtmlNodeUtil.getEndTagString0(tagName);
    }

    protected static String getEndTagString0(String tagName) {
        return "</" + tagName + ">";
    }

    protected static String getStartTagString0(String tagName, Map properties) {
        StringBuffer buf = new StringBuffer(100);
        buf.append("<");
        buf.append(tagName);
        Iterator i = properties.keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            String value = "\"" + properties.get(name) + "\"";
            buf.append(" ");
            buf.append(name);
            buf.append("=");
            buf.append(value);
        }
        return buf.toString();
    }
}

