/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.seasar.framework.util.ClassUtil;

public class EnumUtil {
    private static final String ENUM_SUPPORT_CLASS_NAME = "javax.faces.internal.EnumSupportImpl";
    private static EnumSupport enumSupport = null;

    public static Map convertEnumToName(Map src) {
        if (src == null || src.isEmpty()) {
            return src;
        }
        HashMap<String, EnumHolder> dest = new HashMap<String, EnumHolder>(src.size());
        Iterator it = src.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            Class<?> valueType = value.getClass();
            if (EnumUtil.isEnum(valueType)) {
                EnumHolder holder = new EnumHolder(valueType.getName(), EnumUtil.toName(value));
                dest.put(key, holder);
                continue;
            }
            dest.put(key, (EnumHolder)value);
        }
        return dest;
    }

    public static Map convertNameToEnum(Map src) {
        if (src == null || src.isEmpty()) {
            return src;
        }
        HashMap<String, Object> dest = new HashMap<String, Object>(src.size());
        Iterator it = src.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof EnumHolder) {
                Object enumValue = EnumUtil.toEnum((EnumHolder)value);
                dest.put(key, enumValue);
                continue;
            }
            dest.put(key, value);
        }
        return dest;
    }

    public static boolean isEnum(Class clazz) {
        return enumSupport != null && enumSupport.isEnum(clazz);
    }

    public static String toName(Object enumObject) {
        return enumSupport.toName(enumObject);
    }

    public static Object toEnum(EnumHolder enumHolder) {
        return enumSupport.toEnum(ClassUtil.forName((String)enumHolder.enumType), enumHolder.name);
    }

    public static Object toEnum(Class enumType, String name) {
        return enumSupport.toEnum(enumType, name);
    }

    static {
        try {
            enumSupport = (EnumSupport)ClassUtil.newInstance((String)ENUM_SUPPORT_CLASS_NAME);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static class EnumHolder {
        public String enumType;
        public String name;

        public EnumHolder(String enumType, String name) {
            this.enumType = enumType;
            this.name = name;
        }
    }

    public static interface EnumSupport {
        public boolean isEnum(Class var1);

        public String toName(Object var1);

        public Object toEnum(Class var1, String var2);
    }
}

