/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import javax.faces.internal.IgnoreAttribute;
import javax.faces.internal.SelectItemsIterator;
import javax.faces.internal.UIComponentUtil;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.seasar.framework.util.ArrayIterator;
import org.seasar.framework.util.ArrayUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.render.AbstractInputRenderer;
import org.seasar.teeda.core.util.RendererUtil;
import org.seasar.teeda.core.util.ValueHolderUtil;

public class HtmlSelectManyCheckboxRenderer
extends AbstractInputRenderer {
    public static final String COMPONENT_FAMILY = "javax.faces.SelectMany";
    public static final String RENDERER_TYPE = "javax.faces.Checkbox";
    private final IgnoreAttribute ignoreComponent = new IgnoreAttribute();
    protected static final String[] TABLE_ATTRIBUTES = new String[]{"border", "style", "styleClass"};

    public HtmlSelectManyCheckboxRenderer() {
        this.ignoreComponent.addAttributeName("id");
        this.ignoreComponent.addAttributeName("value");
        this.ignoreComponent.addAttributeName("layout");
        this.ignoreComponent.addAttributeName("disabled");
        this.ignoreComponent.addAttributeName("disabledClass");
        this.ignoreComponent.addAttributeName("enabledClass");
        this.ignoreComponent.addAttributeName("border");
        this.ignoreComponent.addAttributeName("style");
        this.ignoreComponent.addAttributeName("styleClass");
        this.ignoreComponent.addAttributeName("name");
        this.ignoreComponent.addAttributeName("type");
        this.ignoreComponent.addAttributeName("checked");
        this.ignoreComponent.addAttributeName("selectedValues");
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        this.encodeHtmlSelectManyCheckboxEnd(context, component);
    }

    protected void encodeHtmlSelectManyCheckboxEnd(FacesContext context, UIComponent htmlSelectManyCheckbox) throws IOException {
        SelectItemsIterator it = new SelectItemsIterator(htmlSelectManyCheckbox);
        if (!it.hasNext()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        boolean noneLayout = this.isNoneLayout(htmlSelectManyCheckbox);
        if (!noneLayout) {
            writer.startElement("table", htmlSelectManyCheckbox);
            RendererUtil.renderIdAttributeIfNecessary(writer, htmlSelectManyCheckbox, this.getIdForRender(context, htmlSelectManyCheckbox));
            RendererUtil.renderAttributes(writer, htmlSelectManyCheckbox, TABLE_ATTRIBUTES);
        }
        String[] selectedValues = this.getValuesForRender(context, htmlSelectManyCheckbox);
        boolean pageDirectionLayout = this.isPageDirectionLayout(htmlSelectManyCheckbox);
        if (!noneLayout && !pageDirectionLayout) {
            writer.startElement("tr", htmlSelectManyCheckbox);
        }
        this.renderSelectItems(context, htmlSelectManyCheckbox, writer, it, selectedValues, pageDirectionLayout, noneLayout);
        if (!noneLayout) {
            if (!pageDirectionLayout) {
                writer.endElement("tr");
            }
            writer.endElement("table");
        }
    }

    protected String[] getValuesForRender(FacesContext context, UIComponent htmlSelectManyCheckbox) {
        return ValueHolderUtil.getValuesForRender(context, htmlSelectManyCheckbox);
    }

    protected void renderSelectItems(FacesContext context, UIComponent htmlSelectManyCheckbox, ResponseWriter writer, Iterator it, String[] selectedValues, boolean pageDirectionLayout, boolean noneLayout) throws IOException {
        while (it.hasNext()) {
            SelectItem selectItem = (SelectItem)it.next();
            if (!noneLayout) {
                if (pageDirectionLayout) {
                    writer.startElement("tr", htmlSelectManyCheckbox);
                }
                writer.startElement("td", htmlSelectManyCheckbox);
            }
            if (selectItem instanceof SelectItemGroup) {
                this.renderSelectItemGroup(context, htmlSelectManyCheckbox, writer, selectedValues, selectItem, pageDirectionLayout, noneLayout);
            } else {
                this.renderSelectItem(context, htmlSelectManyCheckbox, writer, selectedValues, selectItem);
            }
            if (noneLayout) continue;
            writer.endElement("td");
            if (!pageDirectionLayout) continue;
            writer.endElement("tr");
        }
    }

    protected void renderSelectItemGroup(FacesContext context, UIComponent htmlSelectManyCheckbox, ResponseWriter writer, String[] selectedValues, SelectItem selectItem, boolean pageDirectionLayout, boolean noneLayout) throws IOException {
        SelectItemGroup selectItemGroup = (SelectItemGroup)selectItem;
        Object[] selectItems = selectItemGroup.getSelectItems();
        ArrayIterator selectItemsIt = new ArrayIterator(selectItems);
        if (!noneLayout) {
            writer.startElement("table", htmlSelectManyCheckbox);
            if (!pageDirectionLayout) {
                writer.startElement("tr", htmlSelectManyCheckbox);
            }
        }
        this.renderSelectItems(context, htmlSelectManyCheckbox, writer, (Iterator)selectItemsIt, selectedValues, pageDirectionLayout, noneLayout);
        if (!noneLayout) {
            if (!pageDirectionLayout) {
                writer.endElement("tr");
            }
            writer.endElement("table");
        }
    }

    protected void renderSelectItem(FacesContext context, UIComponent htmlSelectManyCheckbox, ResponseWriter writer, String[] selectedValues, SelectItem selectItem) throws IOException {
        writer.startElement("label", htmlSelectManyCheckbox);
        boolean disabled = UIComponentUtil.isDisabled(htmlSelectManyCheckbox) || selectItem.isDisabled();
        String labelClass = this.getLabelStyleClass(htmlSelectManyCheckbox, disabled);
        if (labelClass != null) {
            RendererUtil.renderAttribute(writer, "class", (Object)labelClass);
        }
        this.renderInputElement(context, htmlSelectManyCheckbox, writer, selectedValues, selectItem, disabled);
        String label = selectItem.getLabel();
        if (!StringUtil.isEmpty((String)label)) {
            writer.writeText(label, null);
        }
        writer.endElement("label");
    }

    protected void renderInputElement(FacesContext context, UIComponent htmlSelectManyCheckbox, ResponseWriter writer, String[] selectedValues, SelectItem selectItem, boolean disabled) throws IOException {
        writer.startElement("input", htmlSelectManyCheckbox);
        RendererUtil.renderAttribute(writer, "type", (Object)"checkbox");
        RendererUtil.renderAttribute(writer, "name", (Object)htmlSelectManyCheckbox.getClientId(context));
        Object value = selectItem.getValue();
        RendererUtil.renderAttribute(writer, "value", value);
        this.renderRemainAttributes(htmlSelectManyCheckbox, writer, this.ignoreComponent);
        if (this.isChecked(selectedValues, value.toString())) {
            this.renderCheckedAttribute(writer);
        }
        if (disabled) {
            this.renderDisabledAttribute(writer);
        }
        writer.endElement("input");
    }

    protected boolean isPageDirectionLayout(UIComponent htmlSelectManyCheckbox) {
        return "pageDirection".equals(UIComponentUtil.getStringAttribute(htmlSelectManyCheckbox, "layout"));
    }

    protected boolean isNoneLayout(UIComponent htmlSelectManyCheckbox) {
        return "none".equals(UIComponentUtil.getStringAttribute(htmlSelectManyCheckbox, "layout"));
    }

    protected boolean isChecked(String[] selectedValues, String value) {
        return ArrayUtil.contains((Object[])selectedValues, (Object)value);
    }

    public void decode(FacesContext context, UIComponent component) {
        this.assertNotNull(context, component);
        this.getDecoder().decodeMany(context, component);
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        this.assertNotNull(context, component);
        return RendererUtil.getConvertedUIOutputValues(context, (UIOutput)component, submittedValue);
    }

    public void addIgnoreAttributeName(String name) {
        this.ignoreComponent.addAttributeName(name);
    }
}

