/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.faces.context.FacesContext;
import javax.faces.internal.FacesMessageUtil;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.teeda.extension.component.html.THtmlCommandButton;
import org.seasar.teeda.extension.util.DoubleSubmitProtectionLoader;
import org.seasar.teeda.extension.util.JavaScriptProvider;
import org.seasar.teeda.extension.util.VirtualResource;

public class KumuDisabledScriptLoader
implements DoubleSubmitProtectionLoader {
    protected static final Pattern pattern = Pattern.compile("Items:");

    public void loadScript(FacesContext context, THtmlCommandButton button) {
        JavaScriptProviderImpl provider;
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        AssertionUtil.assertNotNull((String)"button", (Object)((Object)button));
        String path = ResourceUtil.getResourcePath((String)"org.seasar.teeda.ajax.js.kumu", (String)"js");
        VirtualResource.addJsResource(context, path);
        VirtualResource.addJsResource(context, ResourceUtil.getResourcePath((String)"org.seasar.teeda.ajax.js.event", (String)"js"));
        VirtualResource.addJsResource(context, ResourceUtil.getResourcePath((String)"org.seasar.teeda.ajax.js.disabled", (String)"js"));
        String key = this.getClass().getName();
        Map resources = VirtualResource.getInlineJsResources(context);
        if (!resources.containsKey(key)) {
            long time = button.getTime();
            String submitFunction = FacesMessageUtil.getSummary((FacesContext)context, (String)SUBMIT_MESSAGE_KEY, null);
            provider = new JavaScriptProviderImpl(time, submitFunction);
        } else {
            provider = (JavaScriptProviderImpl)resources.get(key);
        }
        provider.addButton(button.getId());
        VirtualResource.addInlineJsResource(context, key, provider);
    }

    public static class JavaScriptProviderImpl
    implements JavaScriptProvider {
        protected long time;
        protected String submitFunction;
        protected List buttons = new ArrayList();

        public JavaScriptProviderImpl(long time, String submitFunction) {
            this.time = time;
            this.submitFunction = submitFunction;
        }

        public void addButton(String id) {
            this.buttons.add(id);
        }

        public String getScript() {
            FacesContext context = FacesContext.getCurrentInstance();
            StringBuffer buf = new StringBuffer(200);
            buf.append("DisabledConf = {\n");
            buf.append(" includeButton : [");
            for (int i = 0; i < this.buttons.size(); ++i) {
                buf.append("'").append((String)this.buttons.get(i)).append("', ");
            }
            buf.setLength(buf.length() - 2);
            buf.append("],\n");
            buf.append(" time : ").append(this.time).append(",\n");
            if (this.submitFunction != null) {
                buf.append(" submitMessage : ");
                buf.append(this.submitFunction).append("\n");
            }
            buf.append("}\n");
            return new String(buf);
        }
    }
}

