/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.render.html;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.seasar.teeda.core.render.AbstractRenderer;
import org.seasar.teeda.extension.util.JavaScriptProvider;
import org.seasar.teeda.extension.util.VirtualResource;

public class THtmlHeadRenderer
extends AbstractRenderer {
    public static final String COMPONENT_FAMILY = "org.seasar.teeda.extension.HtmlHead";
    public static final String RENDERER_TYPE = "org.seasar.teeda.extension.HtmlHead";

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("head", component);
        writer.write("\n");
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        this.renderCssResources(context);
        this.renderJsResources(context);
        this.renderInlineCssResources(context);
        this.renderInlineJsResources(context);
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("head");
        writer.write("\n");
    }

    protected void renderJsResources(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Set jsResources = VirtualResource.getJsResources(context);
        Iterator i = jsResources.iterator();
        while (i.hasNext()) {
            String path = (String)i.next();
            if (path == null) continue;
            String convertedPath = !path.startsWith("../") && !path.startsWith("./") ? VirtualResource.convertVirtualPath(context, path) : path;
            this.renderIncludeJavaScript(writer, convertedPath);
            writer.write("\n");
        }
    }

    protected void renderInlineJsResources(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Collection values = VirtualResource.getInlineJsResourceValues(context);
        Iterator i = values.iterator();
        while (i.hasNext()) {
            Object script = i.next();
            if (script instanceof JavaScriptProvider) {
                this.renderJavaScriptElement(writer, ((JavaScriptProvider)script).getScript());
            } else {
                this.renderJavaScriptElement(writer, (String)script);
            }
            writer.write("\n");
        }
    }

    protected void renderCssResources(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Set cssResources = VirtualResource.getCssResources(context);
        Iterator i = cssResources.iterator();
        while (i.hasNext()) {
            String path = (String)i.next();
            if (path == null) continue;
            String convertedPath = !path.startsWith("../") && !path.startsWith("./") ? VirtualResource.convertVirtualPath(context, path) : path;
            this.renderStyleSheet(writer, convertedPath);
            writer.write("\n");
        }
    }

    protected void renderInlineCssResources(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Collection values = VirtualResource.getInlineCssResourceValues(context);
        Iterator i = values.iterator();
        while (i.hasNext()) {
            writer.write((String)i.next());
        }
    }
}

