/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.convert;

import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;
import javax.faces.convert.ShortConverter;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.extension.convert.ConvertTargetSelectable;
import org.seasar.teeda.extension.convert.ConverterHelper;
import org.seasar.teeda.extension.util.TargetCommandUtil;

public class TShortConverter
extends ShortConverter
implements StateHolder,
ConvertTargetSelectable {
    protected String objectMessageId;
    protected String stringMessageId;
    protected boolean transientValue = false;
    protected String target;
    protected String[] targets;

    public Object getAsObject(FacesContext context, UIComponent component, String value) throws ConverterException {
        AssertionUtil.assertNotNull((String)"FacesContext", (Object)context);
        AssertionUtil.assertNotNull((String)"UIComponent", (Object)component);
        if (!ConverterHelper.isTargetCommand(context, component, this.targets, this)) {
            return value;
        }
        return super.getAsObject(context, component, value);
    }

    public String getObjectMessageId() {
        return !StringUtil.isEmpty((String)this.objectMessageId) ? this.objectMessageId : super.getObjectMessageId();
    }

    public void setObjectMessageId(String objectMessageId) {
        this.objectMessageId = objectMessageId;
    }

    public String getStringMessageId() {
        return !StringUtil.isEmpty((String)this.stringMessageId) ? this.stringMessageId : super.getStringMessageId();
    }

    public void setStringMessageId(String stringMessageId) {
        this.stringMessageId = stringMessageId;
    }

    public boolean isTransient() {
        return this.transientValue;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.objectMessageId = (String)values[0];
        this.stringMessageId = (String)values[1];
        this.target = (String)values[2];
        this.setTarget(this.target);
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.objectMessageId, this.stringMessageId, this.target};
        return values;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
        if (StringUtil.isEmpty((String)target)) {
            return;
        }
        this.targets = StringUtil.split((String)target, (String)", ");
    }

    public boolean isTargetCommandConvert(FacesContext context, String[] targets) {
        return TargetCommandUtil.isTargetCommand(context, targets);
    }

    public void setTransient(boolean transientValue) {
        this.transientValue = transientValue;
    }
}

